/**
 * Copyright @ 2000 Peter Robach (pr@webapp.de) and Lars Rwekamp (Lars@openKnowlege.de)
 *
 * Source is only for non commercialand coaching usage.
 *
 * Not Warranty to use it.
 */

package de.ix.jspTutorial.util;


/**
 * Class to encapsulate <code>null</code> in an object.
 * This class is a singleton.
 *
 * @author 	Peter Robach
 * @version $Id:$
 */
public final class Null
{
   /**
    * The internal <code>null</code>
    */
   static private Object theNull = null;

   /**
    * Delivers a unique object wihout any content.
    *
    * @return The Null-object
    */
   static public Object Null()
   {
      if(theNull == null)
	    {
		      synchronized(Null.class)
      		 {
      		 	 if(theNull == null)
              theNull = new Null();
         }
      }
      return theNull;
   }

   /**
    * Private constructor.
    */
   private Null()
   {
   }

   /**
    * Returns <code>null</code>.
    *
    * @return <code>null</code>
    */
   public String toString()
   {
      return null;
   }

}

// end of class