/**
 * Copyright @ 2000 Peter Robach (pr@webapp.de) and Lars Rwekamp (Lars@openKnowlege.de)
 *
 * Source is only for non commercial and coaching usage.
 *
 * Not Warranty to use it.
 */

package de.ix.jspTutorial.model;
import java.util.*;
import java.io.*;
import java.net.URL;
import javax.servlet.ServletContext;
import de.ix.jspTutorial.constants.SessionConstants ;

/**
 * This class represents a list of different pizza.
 *
 * @author Peter Rossbach (<a href="mailto://pr@webapp.de">pr@webapp.de</a>), Lars Rwekamp ( <a href="mailto://lars.roewekamp@openKnowledge.de">lars.roewekamp@openKnowledge.de</a>)
 * @version $Id:$
 */
public class PizzaList {

  /**
    * list of all possible pizza
    */
  private TreeMap pizzas;

  /**
    * version  of source
    */
  public static String vcid = "$Id:$";

   /**
    * Constructor to create empty list of pizzas
    *
    */
   public PizzaList() {
      this.pizzas = new TreeMap();
   }

  /**
    * Constructor to create ereal list of pizzas
    *
    * @param pizzas lst of pizzas
    *
    */
   public PizzaList(TreeMap pizzas) {
      this.pizzas = pizzas;
   }

   /**
    * Getter method for one specified pizza from the pizza list
    *
    *
    * @param key unique id of the requested pizza
    *
    * @return requested pizza
    *
    */
   public Pizza getPizza(Long key) {
      return (Pizza) pizzas.get(key);
   }

   /**
    * Getter method for attribute <code>pizzas</code>
    *
    *
    * @return current list of pizzas
    *
    */
   public TreeMap getPizzas() {
      return pizzas;
   }

   /**
    * Read pizza list out of the db, using the <code>PizzaAccessor</code> singleton
    *
    * @param aApplication the application
    *
    * @see PizzaAccessor#readPizzaList(ServletContext)
    */
   public void readList(ServletContext aApplication) {

   	  PizzaAccessor theAccessor = (PizzaAccessor) aApplication.getAttribute(SessionConstants.PIZZA_ACCESSOR) ;
   	  if(theAccessor != null) {
   	  	 theAccessor.log("Read Pizza's from JDBC") ;
   	  	 pizzas = theAccessor.readPizzaList(aApplication) ;
   	  } else
				 new RuntimeException ("Can't Access Database for pizza") ;
   }

  /**
    * Build a string out of the pizza list
    *
    * @return String representation of the pizza list
    *
    */
   public String toString() {
      StringBuffer outStr = new StringBuffer();
      Set    entrySet = pizzas.entrySet();

      outStr.append("[") ;
      for (Iterator iter = entrySet.iterator(); iter.hasNext(); ) {
         Map.Entry entry = (Map.Entry) iter.next();

         outStr.append(((Pizza) entry.getValue()).toString()) ;
         if(iter.hasNext())
         		outStr.append(",\n");
      }
      outStr.append("]") ;
      return outStr.toString();
   }
}


//
// History
//
// $Log:$
//
//