/**
 * Copyright @ 2000 Peter Robach (pr@webapp.de) and Lars Rwekamp (Lars@openKnowlege.de)
 *
 * Source is only for non commercial and coaching usage.
 *
 * Not Warranty to use it.
 */

package de.ix.jspTutorial.model;


import org.w3c.dom.Document;
import org.w3c.dom.Element;

import de.ix.jspTutorial.constants.*;

import java.util.*;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpServletRequest;

/**
 * This class represents a personalized pizza including
 * the base pizza and some additional ingredients.
 *
 * @author Peter Rossbach (<a href="mailto://pr@webapp.de">pr@webapp.de</a>), Lars Rwekamp ( <a href="mailto://lars.roewekamp@openKnowledge.de">lars.roewekamp@openKnowledge.de</a>)
 * @version $Id:$
 */
public class PersonalPizza extends Pizza implements XMLConstants, XMLModelInterface {

 /**
  * List of ingredients
  */
   private TreeMap ingredients;


   /**
    * Default Constructor
    */
   public PersonalPizza() {
      this.ingredients = new TreeMap();
   }

   /**
    * Constructor for a real personal pizza
    *
    *
    * @param aRequest current httpRequest
    * @param pizzaId unique id of the requested pizza
    * @param ingredientIds list of unique ids of requested ingredients
    *
    */
   public PersonalPizza(HttpServletRequest aRequest, String pizzaId,
                        String ingredientIds) {
      this.ingredients = new TreeMap();
      HttpSession theSession  = aRequest.getSession(false);

      if (theSession == null) {
         throw new RuntimeException("Session not Ready to order");
      }
      PizzaList      pizzaList = (PizzaList) theSession.getValue("pizzaList");
      IngredientList ingredientList =
         (IngredientList) theSession.getValue("ingredientList");
      Pizza          pizza = pizzaList.getPizza(new Long(pizzaId.trim()));

      this.setPizza(pizza);
      System.out.println(pizza);
      if(ingredientIds != null) {
	      StringTokenizer st = new StringTokenizer(ingredientIds, ",");

	      for (; st.hasMoreElements(); ) {
	         String     s_ingredientId = (String) st.nextElement();
	         Long       ingredientId = new Long(s_ingredientId.trim());
	         Ingredient ingredient = ingredientList.getIngredient(ingredientId);

	         ingredients.put(ingredientId, ingredient);
	      }
      }
   }


 /**
    * Getter method for the attribute <code>ingredients</code>
    *
    * @return current value of the attribute ingredients
    *
    * @see PersonalPizza#setIngredients(java.util.TreeMap)
    */
   public java.util.TreeMap getIngredients() {
      return ingredients;
   }

  /**
    * Setter method for the attribute <code>ingredients</code>
    *
    * @param newIngredients new value for the attribute ingredients
    *
    * @see PersonalPizza#getIngredients()
    */
   public void setIngredients(java.util.TreeMap newIngredients) {
      this.ingredients = newIngredients;
   }

  /**
    * Getter method for the attribute <code>pizza</code>
    *
    * @return current value of the attribute pizza
    *
    * @see PersonalPizza#setPizza(Pizza)
    */
   public Pizza getPizza() {
      return (Pizza) this;
   }

   /**
    * Setter method for the attribute <code>pizza</code>
    *
    * @param newPizza new value for the attribute pizza
    *
    * @see PersonalPizza#getPizza()
    */
   public void setPizza(Pizza newPizza) {
      this.setId(newPizza.getId());
      this.setBasePrice(newPizza.getBasePrice());
      this.setName(newPizza.getName());
      this.setSize(newPizza.getSize());
   }


   /**
    * Calc price of current personal pizza.
    *
    * @return the total cost of the pizza
    *
    */
   public double calcTotalPrice() {
      double        additionalPrice = 0.0;
      java.util.Set entrySet = ingredients.entrySet();

      for (Iterator iter = entrySet.iterator(); iter.hasNext(); ) {
         System.out.println("Entry found - try to get it ");
         Map.Entry entry = (Map.Entry) iter.next();

         System.out.println("Entry found - got it ");
         System.out.println("Try to get entry : " + entry.getValue());
         Ingredient ingredient = (Ingredient) entry.getValue();

         System.out.println("Try to get price : " + entry.getValue());
         double price = ingredient.getPrice();

         additionalPrice += price;
      }
      System.out.println("OK");
      return getBasePrice() + additionalPrice;
   }


  /**
   * method to generate XML Element containing all
   * important <code>PersonalPizza</code> information
   *
   * @param  document XML Document, to create xml element
   * @return xml element containing XML representation of PersonalPizza
   */
  public Element generateXML(Document document) {

    Element personalPizza = (Element) document.createElement(XML_PERSONAL_PIZZA_TAG);

    Element name   = (Element) document.createElement(XML_NAME_TAG);
    name.appendChild(document.createTextNode(this.getName()));

    Element size    = (Element) document.createElement(XML_SIZE_TAG);
    size.appendChild(document.createTextNode(this.getSize()));

    Element price    = (Element) document.createElement(XML_PRICE_TAG);

    double priceValue  = this.getBasePrice();
    Double priceValueD = new Double(priceValue);

    price.appendChild(document.createTextNode(priceValueD.toString()));

    Element ingredientList = (Element) document.createElement(XML_INGREDIENT_LIST_TAG);

    java.util.Set entrySet = ingredients.entrySet();
    for (Iterator iter = entrySet.iterator(); iter.hasNext(); ) {

      Map.Entry entry = (Map.Entry) iter.next();
      Ingredient ingredientValue = (Ingredient) entry.getValue();

      Element ingredient = ingredientValue.generateXML(document);
      ingredientList.appendChild(ingredient);

    }

    personalPizza.appendChild(name);
    personalPizza.appendChild(size);
    personalPizza.appendChild(price);
    personalPizza.appendChild(ingredientList);

    return personalPizza;
  }

}


//
// History
//
// $Log:$
//
//