/**
 * Copyright @ 2000 Peter Robach (pr@webapp.de) and Lars Rwekamp (Lars@openKnowlege.de)
 *
 * Source is only for non commercial and coaching usage.
 *
 * Not Warranty to use it.
 */
package de.ix.jspTutorial.model;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import de.ix.jspTutorial.constants.*;

import de.ix.jspTutorial.database.* ;
import java.util.* ;

/**
 * This class represents a full pizza order including
 * the base pizza, additional ingredients and the delivery
 * address
 *
 * @author Peter Rossbach (<a href="mailto://pr@webapp.de">pr@webapp.de</a>), Lars Rwekamp ( <a href="mailto://lars.roewekamp@openKnowledge.de">lars.roewekamp@openKnowledge.de</a>)
 * @version $Id:$
 */
public class Order implements XMLConstants, XMLModelInterface {


  /**
    * version of the source
    */
  public static String vcid = "$Id:$";

  /**
   * unique id of the order
   */
  private long id;

  /**
   * total cost of the order
   */
   private double price;

  /**
   * delivery address
   */
   private Customer customer;

  /**
   * ordered pizza including additional ingredients
   */
   private PersonalPizza pizza;

   /**
    * Constructor for an empty order. All strings are set to <code>null</code>,
    * all numeric values to -1 or -1.0
    *
    */
   public Order() {
      this.customer = null;
      this.pizza = null;
      this.id = -1;
      this.price = -1.0;
   }

   /**
    * Constructor for a real order
    *
    *
    * @param id unique id
    * @param customer delivery address
    * @param pizza pizza, including additional ingredients
    * @param price total cost
    *
    */
   public Order(long id, Customer customer, PersonalPizza pizza,
                double price) {
      this.id = id;
      this.customer = customer;
      this.pizza = pizza;
      this.price = price;
   }

   /**
    * Method to create a generic object
    *
    * @return a DatabaseGenericObject
    *
    * @see de.ix.jspTutorial.database.DatabaseGenericModifier#create(I_DatabaseGenericObject,String)
    */
    public DatabaseGenericObject getGenericObject(){
       DatabaseGenericObject theDbOrder =
   	     new DatabaseGenericObject() ;
       theDbOrder.putValue("id",new Long(getId())) ;
       theDbOrder.putValue("price",new Double(getPrice())) ;
       theDbOrder.putValue("customerid",new Long(getCustomer().getId())) ;
       return theDbOrder ;
    }

   /**
    * Create the pizza out of the current order for database storage.
    *
    * @return a DatabaseGenericObject
    *
    * @see de.ix.jspTutorial.database.DatabaseGenericModifier#create(I_DatabaseGenericObject,String)
    */
    public DatabaseGenericObject getPizzaGenericObject() {
      DatabaseGenericObject theDbPizza = pizza.getPizza().getGenericObject() ;
      theDbPizza.putValue("pizzaorderid",new Long(getId())) ;
      return theDbPizza ;
    }

   /**
    * Create a list of ingredients out of the current order for database storage.
    *
    * @return a list of ingredients
    *
    * @see de.ix.jspTutorial.database.DatabaseGenericModifier#create(I_DatabaseGenericObject,String)
    */
   public List getIngredientGenericObjects(){
       ArrayList theDbIngredients = new ArrayList() ;
       for (Iterator it=pizza.getIngredients().entrySet().iterator();it.hasNext();) {
	  Map.Entry entry = (Map.Entry) it.next();
          Ingredient theIngredient = (Ingredient) entry.getValue();

	  DatabaseGenericObject theDbIngredient = theIngredient.getGenericObject() ;
	  theDbIngredient.putValue("pizzaorderid",new Long(getId())) ;
	  theDbIngredients.add(theDbIngredient) ;
	  System.out.println("Ingredient " + theDbIngredient) ;
        }
	return theDbIngredients ;
   }

    /**
    * Setter method for the attribute <code>pizza</code>
    *
    * @param aPizza new value for the attribute pizza
    *
    * @see Order#getPersonalPizza()
    */
   public void setPizza(PersonalPizza aPizza) {
      this.pizza = aPizza;
   }

 /**
    * Getter method for the attribute <code>pizza</code>
    *
    * @return current value of the attribute pizza
    *
    * @see Order#setPizza(PersonalPizza)
    */
   public PersonalPizza getPersonalPizza() {
      return pizza;
   }

   /**
    * Setter method for the attribute <code>customer</code>
    *
    * @param aCustomer new value for the attribute customer
    *
    * @see Order#getCustomer()
    */
   public void setCustomer(Customer aCustomer) {
      this.customer = customer;
   }

  /**
    * Getter method for the attribute <code>customer</code>
    *
    * @return current value of the attribute customer
    *
    * @see Order#setCustomer(Customer)
    */
   public Customer getCustomer() {
      return customer;
   }

   /**
    * Setter method for the attribute <code>price</code>
    *
    * @param aPrice new value for the attribute price
    *
    * @see Order#getPrice()
    */
   public void setPrice(double aPrice) {
      this.price = aPrice;
   }

  /**
    * Getter method for the attribute <code>price</code>
    *
    * @return current value of the attribute price
    *
    * @see Order#setPrice(double)
    */
   public double getPrice() {
      return price;
   }

   /**
    * Setter method for the attribute <code>id</code>
    *
    * @param aId new value for the attribute id
    *
    * @see Order#getId()
    */
   public void setId(long aId) {
      this.id = aId;
   }

 /**
    * Getter method for the attribute <code>id</code>
    *
    * @return current value of the attribute id
    *
    * @see Order#setId(long)
    */
   public long getId() {
      return id;
   }


  /**
   * method to generate XML Element containing all
   * important <code>Order</code> information
   *
   * @param  document XML Document, to create xml element
   * @return xml element containing XML representation of PersonalPizza
   */
  public Element generateXML(Document document) {

      // create order element
      Element order = (Element) document.createElement(XML_ORDER_TAG);

      // add personal pizza data to order
      Element personalPizza = this.getPersonalPizza().generateXML(document);
      order.appendChild(personalPizza);

      // add price data to order
      Element price = (Element) document.createElement(XML_PRICE_TAG);

      double priceValue  = this.getPrice();
      Double priceValueD = new Double(priceValue);
      price.appendChild(document.createTextNode(priceValueD.toString()));
      order.appendChild(price);

      // add customer data to order
      Element customer = this.getCustomer().generateXML(document);
      order.appendChild(customer);

      return order;
    }


  /**
    * Build a string out of the order attributes.
    *
    * @return String representation of the order
    *
    */
   public String toString() {
      return "Customer: " + customer + "  id: " + id
             + "  price: " + price + " pizza " + pizza ;
   }
}

//
// History
//
// $Log:$
//
//