/**
 * Copyright @ 2000 Peter Robach (pr@webapp.de) and Lars Rwekamp (Lars@openKnowlege.de)
 *
 * Source is only for non commercialand coaching usage.
 *
 * Not Warranty to use it.
 */

package de.ix.jspTutorial.exception;

import java.util.Collection;

/**
 * This special exception is thrown by the <code>RequestProcessor</code>
 * when a request did not contain all of the requested parameters.
 *
 * The exception contains a list of missing input parameters.
 *
 */
public class MissingInputParamsException extends Exception {

    private Collection missingInputParams;
    private String errorMessage;


    /**
      * constructor
      *
      * @param errorMessage String, that should/could be shown on an error page
      * @param missingInputParams list of missing input parameters
      *
      */
    public MissingInputParamsException(String errorMessage, Collection missingInputParams) {
      this.errorMessage       = errorMessage;
    	this.missingInputParams = missingInputParams;
    }

   /**
     * Getter method for the missing input parameters
     *
     * @return Collection missing input parameters
     */
    public Collection getMissingInputParams() {
    	return missingInputParams;
    }

   /**
     * Getter method for the error message
     *
     * @return String error message
     */
    public String getErrorMessage() {
      return errorMessage;
    }

}