/**
 * Copyright @ 2000 Peter Robach (pr@webapp.de)
 * 
 * Source is only for non commercial and coaching usage.
 * 
 * Not Warranty to use it.
 */
 
package de.ix.jspTutorial.database.test ;

import junit.framework.*;
import de.ix.jspTutorial.database.* ;
import java.util.*;
import java.sql.*;


/** TestDatabaseConnection.java

    @see
    @author Peter Rossbach
    @version $Id:$
 */

public class TestDatabaseConnection extends TestCase 
{
	
	private DatabaseConnection myConnection ;
	
  public static Test suite()
	{
		return new TestSuite(TestDatabaseConnection.class) ;
	}

  public TestDatabaseConnection(String name)
  {
    super(name);
  }
  
  protected void setUp()
  { 
  	try {
			// Generate Proxy
	   /* myConnection = 
	    	 new DatabaseConnection(
	      	"solid.jdbc.SolidDriver",
	      	"jdbc:solid://localhost:1313", "Peter"
	      	);	
	     */ 	
	   myConnection = 
	    	 new DatabaseConnection(
	      	"jdbc.idbDriver",
	      	"jdbc:idb:db/sample.prp", "TestTable"
	      	);
	    assertEquals("TestTable",myConnection.getDescription()) ; 		
			assert(!myConnection.isConnected());
			assertNull(myConnection.createStatement());
  	  System.out.println("setUp test") ;
  	} catch ( Exception de) {
  		fail("SetUp Database Connection " + de.getMessage() ) ;
  	}	
  }

  protected void tearDown() 
  {
  	try {
	  	if(myConnection != null) {
	  		myConnection.disconnect() ;
	  		myConnection = null ;
	  		
  	  }
	    System.out.println("tearDown test") ;
  	} catch ( Exception de) {
  		fail("tearDown Database Connection " + de.getMessage() ) ;
  	}	
  }

	protected void accessConnection(DatabaseConnection aConnection)
		throws Exception 
	{
		assertNotNull(aConnection) ;
		assert(aConnection.isConnected());

		Statement theStatement = null ;
		ResultSet theResult = null;
		try {
	    aConnection.begin() ;
			theStatement = aConnection.createStatement() ;
			assertNotNull(theStatement) ;
		
			try {
				theResult = theStatement.executeQuery("SELECT * FROM TestTable") ;
	    	assert(!theResult.next()) ;
	    } finally{
	    	if(theResult != null)
	    		theResult.close() ;
	    }
	    aConnection.commit() ;
    } finally {
    	if(theStatement != null)
				theStatement.close() ;
		}
	}
	

  public void testConnection()
	{
			try {								
				assertNotNull(myConnection);				
				// connect
		    Properties theProp = new Properties() ;
		    theProp.put("user","web") ;
		    theProp.put("password","lication");
		    myConnection.connect(theProp);
				assert(myConnection.isConnected());
				// really Connect
				accessConnection(myConnection) ;

			  // disconnected
				myConnection.disconnect() ;
				assert(!myConnection.isConnected());
				assertNull(myConnection.createStatement());

			} catch ( Exception e) {
				fail("Can't used Connection correct " + e.getMessage()  ) ;			
			}
	}
	
	public void testCommit()
	{
			try {
				assertNotNull(myConnection);				
				myConnection.connect("web","lication") ;
				assert(myConnection.isConnected());
				assert(!myConnection.getAutoCommit()) ;
				
				Statement theStatement = null ;
				ResultSet theResult = null ;
				boolean isCorrect = false ;				
				try {
					myConnection.begin() ;
					theStatement = myConnection.createStatement() ;
					isCorrect = 
					  theStatement.executeUpdate(
					  	"INSERT INTO TestTable (ObjectIdentifier,Int1) VALUES ( 'OID1',1)")
					  == 1
					  || 
						theStatement.getUpdateCount() != -1;
					assert(isCorrect) ;
					isCorrect = 
					  theStatement.executeUpdate(
					  	"INSERT INTO TestTable (ObjectIdentifier, Int1) VALUES ( 'OID2',1)")
					  == 1
					  || 
						theStatement.getUpdateCount() != -1;
					assert(isCorrect) ;
					myConnection.commit() ;
					
					myConnection.begin() ;
					theResult = theStatement.executeQuery(
						"SELECT * FROM TestTable") ;
	    		assertNotNull(theResult) ;
					isCorrect = 
					  theStatement.executeUpdate(
					  	"DELETE FROM TestTable ")
					  == 1
					  || 
						theStatement.getUpdateCount() != -1;
					assert(isCorrect) ;
					//myConnection.rollback() ;
	    		myConnection.commit() ;
					
					myConnection.begin() ;
					theResult = theStatement.executeQuery(
						"SELECT * FROM TestTable") ;
	    		assert(!theResult.next()) ;
	    		myConnection.commit() ;
	    		
				} catch (Exception e) {
					myConnection.rollback() ;								
					throw e ;
				}
				finally {
					if(theResult != null)
	    			theResult.close() ;
					if(theStatement != null) {
						myConnection.begin() ;
					  theStatement.executeUpdate(
					  	"DELETE FROM TestTable ") ;
					  myConnection.commit() ;
						theStatement.close() ;
					}

				}
			} catch ( Exception e) {
				fail("Commit test " + e.getMessage() ) ;			
			}
	}
	
} 

// end of class

/**** History ****/

//
// $Log:$
//