/**
 * Copyright @ 2000 Peter Robach (pr@webapp.de)
 * 
 * Source is only for non commercial and coaching usage.
 * 
 * Not Warranty to use it.
 */
 
package de.ix.jspTutorial.database.test ;

import junit.framework.*;
import de.ix.jspTutorial.database.* ;
import java.util.*;
import java.sql.*;


/** TestDBModifier.java

    @see
    @author Peter Rossbach
    @version $Id:$
 */

public class TestDBModifier extends TestCase 
{

	private DatabaseGenericModifier  myModifier;
	private int  myCounter = 1000;
	
  public static Test suite()
	{
		return new TestSuite(TestDBModifier.class) ;
	}

  public TestDBModifier(String name)
  {
    super(name);
  }

  protected DatabaseGenericModifier getModifier() { return myModifier ;}
  
  protected void setUp()
  { 
    myModifier = new DatabaseGenericModifier();
    try {
 /*     	DatabaseConnection theConnection = 
	    	 new DatabaseConnection(
	      	"solid.jdbc.SolidDriver",
	      	"jdbc:solid://localhost:1313", "TestTable"
	      	);	
	*/
	DatabaseConnection theConnection = 
	    	 new DatabaseConnection(
	      	"jdbc.idbDriver",
	      	"jdbc:idb:db/sample.prp", "TestTable"
	      	);
      theConnection.connect("web","lication") ;
      myModifier.setConnection(theConnection);

		} catch (Exception e) {
			fail("Can't setup Modifier correct " + e.getMessage() ) ;
		}
	  System.out.println("Modifier" + getModifier());
  }

  protected void tearDown() 
  {
  	try {
  		if(myModifier != null)
	  		myModifier.getConnection().disconnect() ;
		} catch (Exception e) {
			fail("Can't close Modifier correct " + e.getMessage() ) ;
		}
  }
	
	protected I_DatabaseGenericObject newObject(String aName)
	{
		I_DatabaseGenericObject theObject = new DatabaseGenericObject() ;
		theObject.putValue("ObjectIdentifier", String.valueOf(myCounter)) ;
		myCounter++ ;
		theObject.putValue("String1", aName) ;
		return theObject ;
	}

  public void testModifier()
	{
	  	DatabaseConnection theConnection = null ;
			try {				
				assertNotNull("My Modifier is not set",getModifier()) ;
	      theConnection = getModifier().getConnection() ;
	      assertNotNull("Connection not set", theConnection) ;
				Statement theStatement = getModifier().getConnection().createStatement() ;					
				if(theStatement != null) {
				  theStatement.executeUpdate(
				  	"DELETE FROM TestTable ") ;
				  theConnection.commit() ;
					theStatement.close() ;
				}
				try {
					theConnection.begin() ;			
					I_DatabaseGenericObject theObject = newObject("Peter") ;
					assert("Object not created",myModifier.create(theObject,"TestTable") );	
				  System.out.println("Object created " + theObject ) ;
	    		theConnection.commit() ;
	    		
	    		theConnection.begin() ;
	    		theObject.putValue("String1","Regina") ;
 					assert("Object not created",myModifier.update(theObject,"TestTable","ObjectIdentifier") );
	    		theConnection.commit() ;
	    		
	    	} catch (Exception e) {
	    	  if(theConnection != null) 
							theConnection.rollback() ;								
					throw e ;
				}
			} catch ( Exception e) {
				fail("Can't used Modifier correct " + e.getMessage() ) ;			
			}
	}
} 

// end of class

/**** History ****/

//
// $Log:$
//