/**
 * Copyright @ 2000 Peter Robach (pr@webapp.de)
 *
 * Source is only for non commercial and coaching usage.
 *
 * Not Warranty to use it.
 */

package de.ix.jspTutorial.database;

import java.sql.*;
import java.util.*;

/**
 * Diese Klasse bildet eine kleine Kapsel um das Absetzen einer
 *   beliebige SQL-Query.  Die Klasse verwendet dazu eine von aussen zu
 *   spezifizieren Connection. Auf der Connection werden mittels
 *   Statement die SQL-Queries abgesetzt. Das so erhaltetne ResultSet
 *   wird in ResultObjects verpackt.
 *
 *   <p>
 *   Nachfolgend ein Code-Fragment, welches die Anwendung des Retrievers
 *   zeigt:
 *   <p><xmp>
 *   DatabaseRetriever retriever = new DatabaseRetriever();
 *   DatabaseConnection theConnection = new DatabaseConnection(
 *	    "jdbc.idbDriver",
 * 	  "jdbc:idb:/jspTutorial_II/source/jspTutorial-app/WEB-INF/config/idb/jspTutorial.prp"
 *   theConnection.connect("jsp", "tutorial")
 *   retriever.setConnection(theConnection) ;
 *   try {
 *
 *     theConnection = retriever.getConnection()
 *     theConnection.begin();
 *
 *     ReferenceVector objects  = retriever.retrieve("select * from Pizza");
 *     for (Enumeration e=objects.elements(); e.hasMoreElements();) {
 *       I_DatabaseObject object = (I_DatabaseObject) e.nextElement();
 *       System.out.println(object);
 *      }
 *
 *     theConnection.commit();
 *
 *   } catch (Exception e) {
 *     theConnection.rollback();
 *     e.printStackTrace();
 *   }
 *		finally {
 *   	theConnection.disconnect() ;
 *		}
 *   </xmp>
 *
 *   <p>Wie an dem Fragment erkennbar, ist fr jeden Store
 *   ein Retriever hinterlegt.
 *   Zuerst wird sich daher dieser Retriever besorgt, ein
 *   Transaktionsrahmen aufgebaut , sowie die Query ausgefhrt.
 *
 * @author Peter Rossbach (<a href="mailto://pr@webapp.de">pr@webapp.de</a>)
 * @version $Id:$
 */
public class DatabaseRetriever
{
  /** Version der Klasse */
  public static String vcid ="$Id:$";

   /**
    * Die JDBC-Connection
    */
   private DatabaseConnection myConnection = null;

	public DatabaseRetriever() {}

	public DatabaseRetriever(DatabaseConnection aConnection) {
	  setConnection(aConnection) ;
	}

  /** Diese Methode liefert den Wert des Attributes Connection.
      @return Wert der Variablen myConnection.
      */
  public DatabaseConnection getConnection() { return myConnection; }


	public void setConnection(DatabaseConnection aConnection)
	{
		 	myConnection = aConnection ;
	}

  public List retrieve(String aSQLQueryString,String aType)
  	throws SQLException
  {
  	return retrieve(aSQLQueryString, aType, new DatabaseGenericBinder() );
  }

  /** Die Methode fhrt die SQL Anweisung aus und liefert das Resultat
      zurck.

      @param aSQLQueryString

      @return List der Objekte
  */
  public List retrieve(String aSQLQueryString,String aType, I_DatabaseBinder aBinder)
  	throws SQLException
  {
	  ArrayList objects = new ArrayList();
  	if(myConnection != null) {

			Statement theStatement = null ;
			ResultSet result = null ;
			try {

		     theStatement = myConnection.createStatement();
		     result = theStatement.executeQuery(aSQLQueryString);

		    if (result != null &&
					  result.next()) {
	      	do {
	        	 objects.add(aBinder.bind(aType,result));
	      	} while(result.next()) ;
		    }
			} finally {
				if(result != null)
					result.close() ;
				if(theStatement != null)
	      	theStatement.close();
	    }
  	}

    return objects;
  }

   	/** Die Methode fhrt die Query aus und liefert die erste Zeile des
      Query-Result zurck. Der Rest des Resultset geht dabei
      verloren. Der groer Vorteil dieser Methode gegenber fetch ist,
      dass sofort ein Objekt vom Typ I_DatabaseObject zurckkommt sowie
      die Bestimmung dieses Objektes wesentlich schneller geht.

      @param aSQLQueryString

      @return Objekt vom Typ I_DatabaseObject
  */
  public I_DatabaseObject retrieveOne(String aSQLQueryString)
   throws SQLException {
	  I_DatabaseObject object = null;
   	if(myConnection != null) {

			Statement theStatement = null ;
			ResultSet result = null ;
			I_DatabaseBinder theBinder = new DatabaseGenericBinder() ;
			try {
	      theStatement = myConnection.createStatement();
	      result = theStatement.executeQuery(aSQLQueryString);
	      if (result != null &&
	      	  result.next()) {
		      object = theBinder.bind(null,result) ;
	      }
			} finally {
				if(result != null)
					result.close() ;
				if(theStatement != null)
	      	theStatement.close();
	    }
   	}
    return object;
  }

} // end of class


//
// History:
//
// $Log:$
//
//



