/**
 * Copyright @ 2000 Peter Robach (pr@webapp.de)
 * 
 * Source is only for non commercial and coaching usage.
 * 
 * Not Warranty to use it.
 */
package de.ix.jspTutorial.database ;


/**
 * Defintion einer Datenbank-Ausnahme
 * @author Peter Rossbach (<a href="mailto://pr@webapp.de">pr@webapp.de</a>)
 * @version $Id:$
 */
public class DatabaseException extends Exception 
{
   /**
    * Version  des Source
    */
   public static String vcid = "$Id:$";

  /**
    * Alle weiteren Exceptions
    */
   protected Throwable myThrowable;

   /**
    * Beschreibung des Fehlers ist aus Throwable zu bekommen.
    *
    * @param aThrowable Exception die zum Abbruch fhrte
    * @see #getThrowable()
    */
   public DatabaseException(Throwable aThrowable)
   {
      myThrowable = aThrowable;
   }

   /**
    * Setze Nachricht, die die Exception beschreibt.
    *
    * @param aMessage
    * @see #getMessage()
    */
   public DatabaseException(String aMessage)
   {
      super(aMessage);
   }

   /**
    * Setze Nachricht die Exception beschreibt.
    *
    * @param aMessage Beschreibung des Fehlers
    * @param aThrowable Throwbale, das zum Abbruch fhrte
    * @see #getMessage()
    * @see #getThrowable()
    */
   public DatabaseException(String aMessage, Throwable aThrowable)
   {
      this (aMessage);
      myThrowable = aThrowable;
   }

   /**
    * Setzt das Throwable dieser Exception.
    *
    * @param aThrowable
    */
   public void setThrowable(Throwable aThrowable)
   {
      myThrowable = aThrowable;
   }

   /**
    * Gibt gekapseltes Throwable zurck.
    *
    * @param aThrowable
    */
   public Throwable getThrowable()
   {
      return myThrowable;
   }

}

// end of class

//
// History:
//
// $Log:$
//
//
