/**
 * Copyright @ 2000 Peter Robach (pr@webapp.de) and Lars Rwekamp (Lars@openKnowlege.de)
 *
 * Source is only for non commercialand coaching usage.
 *
 * Not Warranty to use it.
 */
package de.ix.jspTutorial.controller ;

import javax.servlet.* ;
import javax.servlet.http.* ;

import de.ix.jspTutorial.model.* ;
import de.ix.jspTutorial.database.* ;
import de.ix.jspTutorial.constants.SessionConstants ;


/**
 * Initialize a well controlled access to the database. Shuting down the container
 * will also free the accessor
 *
 * @author Peter Rossbach (<a href="mailto://pr@webapp.de">pr@webapp.de</a>), Lars Rwekamp ( <a href="mailto://lars.roewekamp@openKnowledge.de">lars.roewekamp@openKnowledge.de</a>)
 * @version $Id:$
 */
public class JspTutorialStartServlet extends GenericServlet
{
  /**
    * version of source
    */
  public static String vcid = "$Id:$";

  /**
   * Create database connection
   *
   * @param aConfig The servlet configuration
   * @exception ServletException
   */
  public void init(ServletConfig aConfig) throws ServletException  {
      super.init(aConfig);
      ServletContext theContext = aConfig.getServletContext() ;
      theContext.setAttribute(SessionConstants.PIZZA_ACCESSOR,new PizzaAccessor(theContext) );
  }

  /**
    * No service defined
    *
    * @param req current request
    * @param res response object
    * @exception ServletException
    * @exception IOException
    */
  public  void service(ServletRequest req,
                             ServletResponse res)
                      throws ServletException,
                             java.io.IOException  {
    throw new ServletException("No Service only initial application") ;
  }

  /**
    * Close accessor if necessary.
    *
    * @see de.ix.jspTutorial.model.PizzaAccessor
    * @see de.ix.jspTutorial.controller.ModelManager#getPizzaAccessor()
    */
   public void destroy() {
     ServletContext theContext = getServletContext() ;
     PizzaAccessor theAccessor = (PizzaAccessor)theContext.getAttribute(SessionConstants.PIZZA_ACCESSOR) ;
     if(theAccessor != null) {
       try {
   	  theAccessor.getConnection().disconnect() ;
       } catch(DatabaseException de) {
   	  log("Can't close pizza db connection", de) ;
       }
       theContext.removeAttribute(SessionConstants.PIZZA_ACCESSOR) ;
     }
     super.destroy();
   }
} // end of class


//
// History:
//
// $Log:$
//
//