/*
 * Decompiled with CFR 0.152.
 */
package jdbc;

import db.BlobColumn;
import db.Column;
import db.Table;
import db.Trace;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import jdbc.idbConnection;
import jdbc.idbResultSetMetaData;
import jdbc.idbStatement;

public class idbResultsSet
implements ResultSet {
    static int counter;
    static final String[] TRUES;
    Table RStable;
    int numRows;
    int curRow;
    Vector curVals;
    Vector insertRow;
    idbResultSetMetaData meta;
    idbStatement statement;
    int id;
    idbConnection con;
    boolean closed;
    boolean lastWasNull;
    boolean insertInProgress;
    int sqlID;
    int fetchDirection = 0;
    int fetchSize = 0;

    void trace(String string) {
        if (Trace.traceIt(1024)) {
            Trace.traceOut("  Res " + this.id + " " + string);
        }
    }

    void checkClosed() throws SQLException {
        if (this.closed) {
            throw new SQLException("results set is closed");
        }
    }

    synchronized boolean checkNull(int n) {
        this.lastWasNull = false;
        if (this.meta == null || this.curVals.size() == 0) {
            return this.lastWasNull;
        }
        Column column = this.meta.cols[n];
        Object e = this.curVals.elementAt(n);
        if (e == null) {
            return true;
        }
        if (column.isNull(e)) {
            this.lastWasNull = true;
        }
        return this.lastWasNull;
    }

    public synchronized int getRowCount() {
        return this.numRows;
    }

    public synchronized int getCurRow() {
        return this.curRow + 1;
    }

    public void setCurRow(int n) throws SQLException {
        if (n < 1 || n > this.numRows) {
            throw new SQLException("Row number " + n + " is out of range");
        }
        this.curRow = n - 1;
    }

    public boolean absolute(int n) throws SQLException {
        this.trace("absolute: row=" + n);
        if (this.numRows == 0) {
            return false;
        }
        if (n == 0 || n < -1 * this.numRows) {
            this.curRow = 0;
            this.curVals.removeAllElements();
            return false;
        }
        if (n > this.numRows) {
            this.curRow = this.numRows + 1;
            this.curVals.removeAllElements();
            return false;
        }
        this.curRow = n > 0 ? n - 1 : this.numRows + n;
        this.next();
        return true;
    }

    public boolean relative(int n) throws SQLException {
        this.trace("relative: row=" + n);
        int n2 = this.curRow + n;
        if (n2 < 0) {
            n2 = 0;
        }
        return this.absolute(this.curRow + n);
    }

    public void beforeFirst() throws SQLException {
        this.absolute(0);
    }

    public void afterLast() throws SQLException {
        this.absolute(this.numRows + 1);
    }

    public boolean first() throws SQLException {
        this.trace("first");
        return this.absolute(1);
    }

    public boolean last() throws SQLException {
        this.trace("last");
        return this.absolute(this.numRows);
    }

    public int getRow() throws SQLException {
        if (this.isAfterLast()) {
            return 0;
        }
        return this.curRow;
    }

    boolean checkRowNum(int n) throws SQLException {
        return this.curRow == n;
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.checkRowNum(0);
    }

    public boolean isAfterLast() throws SQLException {
        return this.checkRowNum(this.numRows + 1);
    }

    public boolean isFirst() throws SQLException {
        return this.checkRowNum(1);
    }

    public boolean isLast() throws SQLException {
        return this.checkRowNum(this.numRows);
    }

    public synchronized boolean next() throws SQLException {
        this.trace("next: curRow=" + this.curRow);
        this.checkClosed();
        this.clearWarnings();
        if (++this.curRow > this.numRows) {
            this.curVals.removeAllElements();
            return false;
        }
        this.RStable.getRow(this.curRow, this.curVals);
        return true;
    }

    public boolean previous() throws SQLException {
        return this.relative(-1);
    }

    public synchronized void close() throws SQLException {
        this.trace("close");
        if (this.closed) {
            return;
        }
        this.checkClosed();
        this.con.checkCommit(this.sqlID);
        this.closed = true;
        if (this.RStable.getTableType() == 3) {
            this.RStable.dropTable(null);
        }
        this.RStable = null;
        this.curVals = null;
        this.meta = null;
        this.con = null;
    }

    protected void finalize() throws Throwable {
        if (!this.closed) {
            this.close();
        }
    }

    public synchronized boolean wasNull() throws SQLException {
        this.trace("wasNull: " + this.lastWasNull);
        this.checkClosed();
        return this.lastWasNull;
    }

    public synchronized String getString(int n) throws SQLException {
        this.checkClosed();
        if (this.curVals.size() == 0) {
            throw new SQLException("No rows fetched");
        }
        Column column = this.meta.cols[n];
        Object e = this.curVals.elementAt(n);
        if (this.checkNull(n)) {
            return null;
        }
        String string = column.toString(e);
        this.trace("getString: " + string);
        return string;
    }

    public synchronized boolean getBoolean(int n) throws SQLException {
        boolean bl;
        this.checkClosed();
        if (this.curVals.size() == 0) {
            throw new SQLException("No rows fetched");
        }
        if (this.checkNull(n)) {
            return false;
        }
        Object e = this.curVals.elementAt(n);
        if (e instanceof String) {
            String string = (String)e;
            int n2 = 0;
            while (n2 < TRUES.length) {
                if (string.equalsIgnoreCase(TRUES[n2])) {
                    bl = true;
                }
                ++n2;
            }
            bl = false;
        } else {
            Number number;
            bl = e instanceof Boolean ? (Boolean)e : (number = (Number)e).intValue() != 0;
        }
        this.trace("getBoolean: index=" + n + " result=" + bl);
        return bl;
    }

    public synchronized byte getByte(int n) throws SQLException {
        this.checkClosed();
        if (this.curVals.size() == 0) {
            throw new SQLException("No rows fetched");
        }
        if (this.checkNull(n)) {
            return 0;
        }
        byte by = (byte)this.getInt(n);
        this.trace("getByte: index=" + n + " result=" + by);
        return by;
    }

    public synchronized short getShort(int n) throws SQLException {
        this.checkClosed();
        if (this.curVals.size() == 0) {
            throw new SQLException("No rows fetched");
        }
        if (this.checkNull(n)) {
            return 0;
        }
        short s = (short)this.getInt(n);
        this.trace("getShort: index=" + n + " result=" + s);
        return s;
    }

    public synchronized int getInt(int n) throws SQLException {
        this.checkClosed();
        if (this.curVals.size() == 0) {
            throw new SQLException("No rows fetched");
        }
        if (this.checkNull(n)) {
            return 0;
        }
        Object object = this.curVals.elementAt(n);
        this.trace("getInt: index=" + n + " result=" + object);
        if (object instanceof String) {
            object = new Integer((String)object);
        }
        int n2 = ((Number)object).intValue();
        return n2;
    }

    public synchronized long getLong(int n) throws SQLException {
        this.checkClosed();
        if (this.curVals.size() == 0) {
            throw new SQLException("No rows fetched");
        }
        if (this.checkNull(n)) {
            return 0L;
        }
        Object object = this.curVals.elementAt(n);
        this.trace("getLong: index=" + n + " result=" + object);
        if (object instanceof String) {
            object = new Long((String)object);
        }
        long l = ((Number)object).longValue();
        return l;
    }

    public synchronized float getFloat(int n) throws SQLException {
        this.checkClosed();
        if (this.curVals.size() == 0) {
            throw new SQLException("No rows fetched");
        }
        if (this.checkNull(n)) {
            return 0.0f;
        }
        Object object = this.curVals.elementAt(n);
        this.trace("getFloat: index=" + n + " result=" + object);
        if (object instanceof String) {
            object = new Float((String)object);
        }
        float f = ((Number)object).floatValue();
        return f;
    }

    public synchronized double getDouble(int n) throws SQLException {
        this.checkClosed();
        if (this.curVals.size() == 0) {
            throw new SQLException("No rows fetched");
        }
        if (this.checkNull(n)) {
            return 0.0;
        }
        Object object = this.curVals.elementAt(n);
        this.trace("getDouble: index=" + n + " result=" + object);
        if (object instanceof String) {
            object = new Double((String)object);
        }
        double d = ((Number)object).doubleValue();
        return d;
    }

    public synchronized BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        this.checkClosed();
        if (this.curVals.size() == 0) {
            throw new SQLException("No rows fetched");
        }
        if (this.checkNull(n)) {
            return null;
        }
        Object e = this.curVals.elementAt(n);
        this.trace("getBigDecimal: index=" + n + " result=" + e);
        if (e instanceof String) {
            return new BigDecimal((String)e);
        }
        BigDecimal bigDecimal = new BigDecimal(((Number)e).doubleValue());
        return bigDecimal;
    }

    void intToBytes(int n, byte[] byArray, int n2) {
        int n3 = 0;
        while (n3 < 4) {
            byArray[n3 + n2] = (byte)(n & 0xFF);
            n >>= 8;
            ++n3;
        }
    }

    public synchronized byte[] getBytes(int n) throws SQLException {
        this.trace("getBytes: index=" + n);
        this.checkClosed();
        if (this.curVals.size() == 0) {
            throw new SQLException("No rows fetched");
        }
        if (this.checkNull(n)) {
            return null;
        }
        Object object = this.curVals.elementAt(n);
        if (object instanceof String) {
            String string = (String)object;
            byte[] byArray = string.getBytes();
            return byArray;
        }
        if (object instanceof Double) {
            long l = Double.doubleToLongBits((Double)object);
            object = new Long(l);
        }
        if (object instanceof Long) {
            byte[] byArray = new byte[8];
            long l = (Long)object;
            this.intToBytes((int)(l & 0xFFFFFFFFFFFFFFFFL), byArray, 0);
            this.intToBytes((int)l >> 32, byArray, 3);
            return byArray;
        }
        if (object instanceof Float) {
            int n2 = Float.floatToIntBits(((Float)object).floatValue());
            object = new Integer(n2);
        }
        if (object instanceof Integer) {
            byte[] byArray = new byte[4];
            int n3 = (Integer)object;
            this.intToBytes(n3, byArray, 0);
            return byArray;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray.length - 1);
            return byArray2;
        }
        return null;
    }

    public synchronized Date getDate(int n) throws SQLException {
        long l = this.getLong(n);
        if (this.lastWasNull) {
            return null;
        }
        return new Date(l);
    }

    public synchronized Time getTime(int n) throws SQLException {
        long l = this.getLong(n);
        if (this.lastWasNull) {
            return null;
        }
        return new Time(l);
    }

    public synchronized Timestamp getTimestamp(int n) throws SQLException {
        long l = this.getLong(n);
        if (this.lastWasNull) {
            return null;
        }
        return new Timestamp(l);
    }

    public synchronized InputStream getAsciiStream(int n) throws SQLException {
        throw new SQLException("Method not implemented");
    }

    public synchronized InputStream getUnicodeStream(int n) throws SQLException {
        throw new SQLException("Method not implemented");
    }

    public synchronized InputStream getBinaryStream(int n) throws SQLException {
        byte[] byArray = this.getBytes(n);
        ByteArrayInputStream byteArrayInputStream = null;
        if (byArray != null) {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
        }
        this.trace("getBinaryStream: index=" + n);
        return byteArrayInputStream;
    }

    public synchronized String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public synchronized boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public synchronized byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public synchronized short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public synchronized int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public synchronized long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public synchronized float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public synchronized double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public synchronized BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public synchronized byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public synchronized Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public synchronized Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public synchronized Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public synchronized InputStream getAsciiStream(String string) throws SQLException {
        throw new SQLException("Method not implemented");
    }

    public synchronized InputStream getUnicodeStream(String string) throws SQLException {
        throw new SQLException("Method not implemented");
    }

    public synchronized InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public synchronized void clearWarnings() throws SQLException {
    }

    public synchronized String getCursorName() throws SQLException {
        return null;
    }

    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        this.trace("getMetaData");
        this.checkClosed();
        return this.meta;
    }

    public synchronized Object getObject(int n) throws SQLException {
        this.checkClosed();
        if (this.curVals.size() == 0) {
            throw new SQLException("No rows fetched");
        }
        if (this.checkNull(n)) {
            return null;
        }
        Object object = this.curVals.elementAt(n);
        Column column = this.meta.cols[n];
        if (column.getType() == 5) {
            object = this.getDate(n);
        }
        if (!(object instanceof byte[])) {
            this.trace("getObject: index=" + n + " result=" + object);
            return object;
        }
        try {
            Object object2;
            byte[] byArray = (byte[])object;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            dataInputStream.readByte();
            if (byArray[0] == BlobColumn.STRING_BLOB) {
                object2 = new StringBuffer(byArray.length / 2);
                while (dataInputStream.available() > 1) {
                    char c = dataInputStream.readChar();
                    ((StringBuffer)object2).append(c);
                }
                object = ((StringBuffer)object2).toString();
            } else if (byArray[0] == BlobColumn.OBJECT_BLOB) {
                object2 = new ObjectInputStream(byteArrayInputStream);
                try {
                    object = ((ObjectInputStream)object2).readObject();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (object instanceof byte[]) {
                object2 = new byte[byArray.length - 1];
                System.arraycopy(byArray, 1, object2, 0, byArray.length - 1);
                object = object2;
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        this.trace("getObject: index=" + n + " result=" + object);
        return object;
    }

    public synchronized Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public synchronized int findColumn(String string) throws SQLException {
        String string2;
        this.checkClosed();
        int n = 1;
        while (n <= this.meta.getColumnCount()) {
            string2 = this.meta.getColumnName(n);
            if (string2.equalsIgnoreCase(string)) {
                this.trace("findColumn: " + string + " Result=" + n);
                return n;
            }
            ++n;
        }
        n = 1;
        while (n <= this.meta.getColumnCount()) {
            string2 = this.meta.getColumnName(n);
            int n2 = string2.indexOf(46);
            if (n2 != -1) {
                string2 = string2.substring(n2 + 1);
            }
            if (string2.equalsIgnoreCase(string)) {
                this.trace("findColumn: " + string + " Result=" + n);
                return n;
            }
            ++n;
        }
        n = string.indexOf(46);
        if (n != -1) {
            string2 = string.substring(n + 1);
            return this.findColumn(string2);
        }
        throw new SQLException("Column not found: " + string);
    }

    public Reader getCharacterStream(int n) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public Reader getCharacterStream(String string) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return this.getBigDecimal(n, 0);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), 0);
    }

    public void setFetchDirection(int n) throws SQLException {
        this.fetchDirection = n;
    }

    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    public void setFetchSize(int n) throws SQLException {
        this.fetchSize = n;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public int getType() throws SQLException {
        return 1004;
    }

    public int getConcurrency() throws SQLException {
        return 1007;
    }

    public boolean rowUpdated() throws SQLException {
        return false;
    }

    public boolean rowInserted() throws SQLException {
        return false;
    }

    public boolean rowDeleted() throws SQLException {
        return false;
    }

    void updateChecks() throws SQLException {
        if (this.getRow() == 0 && !this.insertInProgress) {
            throw new SQLException("Not positioned on a row");
        }
    }

    public void updateNull(int n) throws SQLException {
        this.updateChecks();
        this.curVals.setElementAt(null, n);
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.updateChecks();
        this.curVals.setElementAt(new Integer(1), n);
    }

    public void updateByte(int n, byte by) throws SQLException {
        this.updateChecks();
        this.curVals.setElementAt(new Byte(by), n);
    }

    public void updateShort(int n, short s) throws SQLException {
        this.updateChecks();
        this.curVals.setElementAt(new Short(s), n);
    }

    public void updateInt(int n, int n2) throws SQLException {
        this.updateChecks();
        this.curVals.setElementAt(new Integer(n2), n);
    }

    public void updateLong(int n, long l) throws SQLException {
        this.updateChecks();
        this.curVals.setElementAt(new Long(l), n);
    }

    public void updateFloat(int n, float f) throws SQLException {
        this.updateChecks();
        this.curVals.setElementAt(new Float(f), n);
    }

    public void updateDouble(int n, double d) throws SQLException {
        this.updateChecks();
        this.curVals.setElementAt(new Double(d), n);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.updateChecks();
        this.curVals.setElementAt(bigDecimal, n);
    }

    public void updateString(int n, String string) throws SQLException {
        this.updateChecks();
        this.curVals.setElementAt(string, n);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.updateChecks();
        byte[] byArray2 = new byte[byArray.length + 1];
        byArray2[0] = BlobColumn.BINARY_BLOB;
        System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
        this.curVals.setElementAt(byArray, n);
    }

    public void updateDate(int n, Date date) throws SQLException {
        this.updateChecks();
        this.curVals.setElementAt(date, n);
    }

    public void updateTime(int n, Time time) throws SQLException {
        this.updateChecks();
        this.curVals.setElementAt(time, n);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.updateChecks();
        this.curVals.setElementAt(timestamp, n);
    }

    void readFromStream(int n, InputStream inputStream, int n2, int n3) throws SQLException {
        this.updateChecks();
        byte[] byArray = new byte[n2 + 1];
        byArray[0] = (byte)n3;
        try {
            inputStream.read(byArray, 1, n2);
        }
        catch (Exception exception) {
            throw new SQLException(exception.toString());
        }
        this.curVals.setElementAt(byArray, n);
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.readFromStream(n, inputStream, n2, BlobColumn.STRING_BLOB);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.readFromStream(n, inputStream, n2, BlobColumn.BINARY_BLOB);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.updateChecks();
        char[] cArray = new char[n2];
        try {
            reader.read(cArray);
        }
        catch (Exception exception) {
            throw new SQLException(exception.toString());
        }
        this.curVals.setElementAt(new String(cArray), n);
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        this.updateObject(n, object);
    }

    public void updateObject(int n, Object object) throws SQLException {
        this.updateChecks();
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            byte[] byArray2 = new byte[byArray.length + 1];
            byArray2[0] = BlobColumn.BINARY_BLOB;
            System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
            object = byArray2;
        }
        this.curVals.setElementAt(object, n);
    }

    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object, n);
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    public void insertRow() throws SQLException {
        Table table = this.checkUpdatable();
        int n = this.meta.getColumnCount();
        Hashtable hashtable = new Hashtable(n, 0.5f);
        int n2 = 1;
        while (n2 <= n) {
            String string = this.meta.getColumnName(n2);
            Object e = this.curVals.elementAt(n2);
            if (e != null) {
                hashtable.put(string, e);
            }
            ++n2;
        }
        table.addRow(hashtable, this.con.trans);
        this.cancelRowUpdates();
    }

    public void updateRow() throws SQLException {
        this.checkOnRow();
        Table table = this.checkUpdatable();
        Vector vector = new Vector(table.getColCount());
        table.getRow(this.curRow, vector);
        int n = this.meta.getColumnCount();
        int n2 = 1;
        while (n2 <= n) {
            String string = this.meta.getColumnName(n2);
            Object e = this.curVals.elementAt(n2);
            int n3 = table.getColIndex(string);
            if (n3 == -1) {
                throw new SQLException("Column " + string + " not found in table " + table.getTableName());
            }
            vector.setElementAt(e, n3);
            ++n2;
        }
        vector.setElementAt(new Integer(0), 0);
        this.deleteRow();
        table.addRow(vector, this.con.trans);
    }

    void checkOnRow() throws SQLException {
        if (this.curRow > 0 && this.curRow <= this.numRows) {
            return;
        }
        if (!this.insertInProgress) {
            return;
        }
        throw new SQLException("Not positioned on a row");
    }

    Table checkUpdatable() throws SQLException {
        Table table = this.RStable.getUnderlyingTable();
        if (table == null) {
            throw new SQLException("Result set is not updatable");
        }
        return table;
    }

    public void deleteRow() throws SQLException {
        this.checkOnRow();
        Table table = this.checkUpdatable();
        int n = this.RStable.getUnderlyingRow(this.curRow);
        table.deleteRow(n, this.con.trans);
    }

    public void refreshRow() throws SQLException {
        this.checkOnRow();
        this.RStable.getRow(this.curRow, this.curVals);
    }

    public void cancelRowUpdates() throws SQLException {
        this.moveToCurrentRow();
        this.insertRow = null;
    }

    public void moveToInsertRow() throws SQLException {
        this.insertInProgress = true;
        if (this.insertRow == null) {
            int n = this.meta.getColumnCount();
            this.insertRow = new Vector(n + 1);
            this.insertRow.setSize(n + 1);
        }
        this.curVals = this.insertRow;
    }

    public void moveToCurrentRow() throws SQLException {
        if (this.insertInProgress) {
            this.insertInProgress = false;
            this.insertRow = (Vector)this.curVals.clone();
            if (this.curRow > 0 && this.curRow <= this.numRows) {
                this.RStable.getRow(this.curRow, this.curVals);
            }
        }
    }

    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    public Object getObject(int n, Map map) throws SQLException {
        throw new SQLException("Method not implemented");
    }

    public Ref getRef(int n) throws SQLException {
        throw new SQLException("Method not implemented");
    }

    public Blob getBlob(int n) throws SQLException {
        throw new SQLException("Method not implemented");
    }

    public Clob getClob(int n) throws SQLException {
        throw new SQLException("Method not implemented");
    }

    public Array getArray(int n) throws SQLException {
        throw new SQLException("Method not implemented");
    }

    public Object getObject(String string, Map map) throws SQLException {
        throw new SQLException("Method not implemented");
    }

    public Ref getRef(String string) throws SQLException {
        throw new SQLException("Method not implemented");
    }

    public Blob getBlob(String string) throws SQLException {
        throw new SQLException("Method not implemented");
    }

    public Clob getClob(String string) throws SQLException {
        throw new SQLException("Method not implemented");
    }

    public Array getArray(String string) throws SQLException {
        throw new SQLException("Method not implemented");
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return this.getDate(n);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        return this.getTime(n);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.getTimestamp(n);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    idbResultsSet(idbStatement idbStatement2, Table table, int n) throws SQLException {
        this.RStable = table;
        this.numRows = this.RStable.getRowCount();
        this.statement = idbStatement2;
        this.con = idbStatement2.con;
        this.sqlID = n;
        this.curVals = new Vector(table.getColCount());
        n = ++counter;
        this.meta = new idbResultSetMetaData(this.RStable);
        if (this.numRows == 0) {
            this.con.checkCommit(this.sqlID);
        }
        this.trace("created: rows,cols=" + this.numRows + "," + table.getColCount());
    }

    static {
        TRUES = new String[]{"T", "TRUE", "Y", "YES"};
    }
}

