/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.Char1String;

public class idbDataOutputStream {
    byte[] buff;
    int count;
    int colCount;
    int[] cache;
    int curCol;

    void writeVarBytes(byte[] byArray) {
        int n = this.count + byArray.length + 64;
        if (n > this.buff.length) {
            byte[] byArray2 = new byte[Math.max(this.buff.length << 1, n)];
            System.arraycopy(this.buff, 0, byArray2, 0, this.count);
            this.buff = byArray2;
        }
        System.arraycopy(byArray, 0, this.buff, this.count, byArray.length);
        this.count += byArray.length;
        ++this.curCol;
    }

    void reset() {
        this.count = 0;
        this.curCol = 0;
    }

    void writeByte(int n) {
        this.buff[this.count++] = (byte)n;
        ++this.curCol;
    }

    void writeInt(int n) {
        if (this.cache == null) {
            this.writeVarInt(n);
            return;
        }
        if (n != this.cache[this.curCol]) {
            this.buff[this.count++] = (byte)(n >>> 24 & 0xFF);
            this.buff[this.count++] = (byte)(n >>> 16 & 0xFF);
            this.buff[this.count++] = (byte)(n >>> 8 & 0xFF);
            this.buff[this.count++] = (byte)(n & 0xFF);
            this.cache[this.curCol] = n;
        } else {
            this.count += 4;
        }
        ++this.curCol;
    }

    void writeVarInt(int n) {
        this.buff[this.count++] = (byte)(n >>> 24 & 0xFF);
        this.buff[this.count++] = (byte)(n >>> 16 & 0xFF);
        this.buff[this.count++] = (byte)(n >>> 8 & 0xFF);
        this.buff[this.count++] = (byte)(n & 0xFF);
    }

    void writeLong(long l) {
        this.writeVarInt((int)(l >>> 32 & 0xFFFFFFFFFFFFFFFFL));
        this.writeVarInt((int)(l & 0xFFFFFFFFFFFFFFFFL));
    }

    void writeFloat(float f) {
        this.writeInt(Float.floatToIntBits(f));
    }

    void writeDouble(double d) {
        this.writeLong(Double.doubleToLongBits(d));
        ++this.curCol;
    }

    void writeString(String string, int n) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        this.writeInt(n2);
        int n3 = 0;
        while (n3 < n2) {
            char c = cArray[n3];
            if (c < '\u0100') {
                this.buff[this.count++] = 0;
                this.buff[this.count++] = (byte)c;
            } else {
                this.buff[this.count++] = (byte)(c >>> 8 & 0xFF);
                this.buff[this.count++] = (byte)(c & 0xFF);
            }
            ++n3;
        }
        this.count += (n - n2) * 2;
    }

    void writeString(Char1String char1String, int n) {
        byte[] byArray = char1String.toByteArray();
        int n2 = byArray.length;
        this.writeInt(n2);
        if (byArray != null) {
            System.arraycopy(byArray, 0, this.buff, this.count, n2);
        }
        this.count += n;
    }

    int size() {
        return this.count;
    }

    public idbDataOutputStream(byte[] byArray, int n) {
        this.buff = byArray;
        this.colCount = n;
        this.cache = new int[n];
    }

    public idbDataOutputStream(int n, int n2) {
        this.buff = new byte[n];
        this.colCount = n2;
        this.cache = new int[n2];
    }
}

