/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.BTreeObject;
import db.BlobColumn;
import db.ByteColumn;
import db.Char1Column;
import db.Column;
import db.CurrencyColumn;
import db.Database;
import db.DateColumn;
import db.DoubleColumn;
import db.FloatColumn;
import db.GrowArray;
import db.IdbVector;
import db.IndexColumn;
import db.IntegerColumn;
import db.Journal;
import db.LongColumn;
import db.RowRangeCache;
import db.SQLProg;
import db.StringColumn;
import db.TableEncrypt;
import db.Trace;
import db.Transaction;
import db.idbDataOutputStream;
import db.idbTrigger;
import db.indexTable;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.sql.SQLException;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Vector;

public class Table
extends Observable
implements BTreeObject {
    static int accessCount;
    public static final int VANILLA_TABLE = 1;
    public static final int INDEX_TABLE = 2;
    public static final int TEMP_TABLE = 3;
    static final int ROW_DELETED = 1;
    static final int EOF_MARKER = -1;
    static final int DEL_BITSET_SZ = 256;
    static final Integer rowdel;
    static final Integer rowvalid;
    String tableName;
    int recLength;
    Vector columnList;
    int rowCount;
    int deletedRowCount;
    Vector indexTables;
    String path;
    File fileDesc;
    RandomAccessFile rndFile;
    FileDescriptor fd;
    ByteColumn controlCol;
    long rowCountPosn;
    long firstRowPosn;
    byte[] bytesOut;
    idbDataOutputStream dataOut;
    ByteArrayInputStream bytesIn;
    DataInputStream dataIn;
    byte[] rowInputBuffer;
    int firstRowCached;
    int cachedRowCount;
    Database dbase;
    Journal journal;
    int firstDeletedRow;
    int rowCacheSize;
    Integer tblID;
    int tableType;
    boolean recovered;
    Transaction lockOwner;
    int lockCount;
    Thread ownerThread;
    int minRowDeleted;
    int maxRowDeleted;
    int prevMax;
    BitSet delRows;
    int[] orderedFields;
    int numOrdered;
    boolean noAutoInc;
    Vector triggers;
    boolean updating;
    boolean modified;
    boolean isClosed;
    boolean transModified;
    boolean fastUpdate;
    int[] order;
    int majVersion;
    int minVersion;
    TableEncrypt encryptor;
    byte[] encryptBuffer;
    int[] colOffsets;
    int lastDecryptedRow;
    boolean addToTableList;
    boolean autoIncOff;
    boolean readAheadLocked;
    Runtime runTime;
    GrowArray fromTable;
    Table underlyingTable;
    int partitionNumber;
    boolean doingRollback;
    byte[] writeBuffer;
    int writeBufferSize;
    int writeBufferOffset;
    int writeBufferRow;

    public int getTableType() {
        return this.tableType;
    }

    void setTablePath() {
        this.path = this.dbase.tablePath;
        if (this instanceof indexTable && this.dbase.indexPath != null) {
            this.path = this.dbase.indexPath;
        }
        if (this.partitionNumber > 0) {
            this.path = this.dbase.partitions.getStringAt(this.partitionNumber - 1);
        }
        if (this.tableType == 3 && this.dbase.tmpPath != null) {
            this.path = this.dbase.tmpPath;
        }
    }

    void construct(String string, Database database, int n) throws IOException, SQLException {
        this.runTime = Runtime.getRuntime();
        if (string == null) {
            if (Trace.traceIt(8)) {
                Trace.traceOut("Creating table null");
            }
        } else if (Trace.traceIt(8)) {
            Trace.traceOut("Creating table " + string);
        }
        this.dbase = database;
        this.partitionNumber = n;
        this.journal = this.dbase.journal;
        this.fastUpdate = this.dbase.fastUpdate;
        Table table = database.getTable(string);
        if (table != null) {
            throw new SQLException("Table alreacy exists: " + string);
        }
        this.columnList = new Vector(10, 10);
        this.indexTables = new Vector(10, 10);
        this.delRows = new BitSet(256);
        this.setTablePath();
        if (string != null) {
            this.tableName = new String(string);
            this.fileDesc = new File(this.path, string + ".tbl");
            if (this.fileDesc.isAbsolute()) {
                // empty if block
            }
            if (this.tableType != 3 || this.dbase.resultsOnDisk) {
                String string2 = "rw";
                if (this.dbase.readOnly) {
                    string2 = "r";
                }
                this.rndFile = new RandomAccessFile(this.fileDesc, string2);
                if (this.tableType != 3) {
                    this.fd = this.rndFile.getFD();
                }
                this.rndFile.writeInt(3);
                this.rndFile.writeInt(13);
                this.rowCountPosn = this.rndFile.getFilePointer();
                this.markDirty();
            }
        }
        this.rowCacheSize = this.dbase.getIntegerProperty("rowCacheSize", "20");
        this.controlCol = new ByteColumn(this, "$$control");
        this.controlCol.setBooleanProperty(3, true);
        this.controlCol.setProperty(4, "0");
        this.controlCol.setCacheCondition(1, 8192);
        this.dbase.traceMemory();
    }

    void saveRowCounts() throws SQLException {
        try {
            this.markDirty();
            int n = 0;
            while (n < this.columnList.size()) {
                Column column = (Column)this.columnList.elementAt(n);
                column.write(this.rndFile);
                ++n;
            }
            this.rndFile.seek(this.rowCountPosn);
            this.rndFile.writeInt(this.rowCount);
            this.rndFile.writeInt(this.deletedRowCount);
            if (this.fd != null) {
                this.fd.sync();
            }
            if (Trace.traceIt(8)) {
                Trace.traceOut(this.tableName + " marked OK");
            }
            this.modified = false;
        }
        catch (Exception exception) {
            throw new SQLException("Error saving row counts " + exception.toString());
        }
    }

    void markDirty() throws SQLException {
        try {
            if (Trace.traceIt(8)) {
                Trace.traceOut(this.tableName + " marked dirty");
            }
            boolean bl = false;
            if (this.rndFile == null) {
                this.rndFile = new RandomAccessFile(this.fileDesc, "rw");
                this.fd = this.rndFile.getFD();
                bl = true;
            }
            this.rndFile.seek(this.rowCountPosn);
            this.rndFile.writeInt(-1);
            this.rndFile.writeInt(0);
            if (this.fd != null) {
                this.fd.sync();
            }
            this.modified = true;
            if (bl) {
                this.rndFile.close();
                this.rndFile = null;
                this.fd = null;
            }
        }
        catch (Exception exception) {
            throw new SQLException("Error saving row counts " + exception.toString());
        }
    }

    synchronized void close(boolean bl) throws IOException, SQLException {
        if (this.isClosed) {
            return;
        }
        if (Trace.traceIt(8)) {
            Trace.traceOut("Closing table " + this.tableName + " Rows " + this.rowCount + " Deleted rows " + this.deletedRowCount);
        }
        if (Trace.traceIt(8)) {
            Trace.traceOut("  Rec len " + this.recLength + " Cols " + this.columnList.size() + " Indexes " + this.indexTables.size());
        }
        if (!this.modified || this.dbase.readOnly) {
            if (Trace.traceIt(8)) {
                Trace.traceOut("  No change");
            }
        } else if (this.tableType != 3 && !bl) {
            this.saveRowCounts();
        }
        if (this.rndFile != null) {
            this.rndFile.close();
        }
        this.isClosed = true;
        int n = 0;
        while (n < this.columnList.size()) {
            Column column = (Column)this.columnList.elementAt(n);
            column.onClose();
            column = null;
            ++n;
        }
        this.columnList = null;
        this.indexTables = null;
    }

    int getIntValByRow(String string, int n) throws SQLException {
        return (Integer)this.getColByRow(string, n);
    }

    synchronized boolean open(String string) throws IOException, SQLException {
        Object object;
        Object object2;
        if (Trace.traceIt(8)) {
            Trace.traceOut("Opening table " + string);
        }
        this.tableName = new String(string);
        this.fileDesc = new File(this.path, string + ".tbl");
        if (!this.fileDesc.exists()) {
            return false;
        }
        if (this.dbase.readOnly) {
            this.rndFile = new RandomAccessFile(this.fileDesc, "r");
        } else {
            this.rndFile = new RandomAccessFile(this.fileDesc, "rw");
            this.fd = this.rndFile.getFD();
        }
        if (this.rndFile.length() < 16L) {
            throw new SQLException("Invalid table file: " + this.path + File.separatorChar + string);
        }
        this.majVersion = this.rndFile.readInt();
        if (this.majVersion > 3) {
            throw new SQLException("Database created with a later version.");
        }
        this.minVersion = this.rndFile.readInt();
        this.rowCountPosn = this.rndFile.getFilePointer();
        this.rowCount = this.rndFile.readInt();
        this.deletedRowCount = this.rndFile.readInt();
        if (this.rowCount == -1) {
            object2 = "Database not shut down cleanly or in use by another program.\nSet recoveryPolicy=1 for automatic recovery.";
            switch (this.dbase.recoveryPolicy) {
                case 1: {
                    this.dbase.doRecovery = true;
                    break;
                }
                case 2: {
                    if (this.dbase.doRecovery) break;
                    System.out.println((String)object2);
                    System.out.println("Note that it is dangerous to proceed if another\nprogram is currently accessing this database.");
                    System.out.println("Should InstantDB attempt recovery now? (y/n)");
                    object = new BufferedReader(new InputStreamReader(System.in));
                    String string2 = "";
                    while (string2.length() == 0) {
                        string2 = ((BufferedReader)object).readLine();
                    }
                    char c = string2.charAt(0);
                    if (c != 'y' && c != 'Y') break;
                    this.dbase.doRecovery = true;
                    break;
                }
            }
            if (this.dbase.doRecovery) {
                this.recovered = true;
            } else {
                this.dbase.close();
                throw new SQLException((String)object2);
            }
        }
        object2 = this.columnList.elements();
        while (object2.hasMoreElements()) {
            object = (Column)object2.nextElement();
            ((Column)object).read(this.rndFile);
        }
        int n = this.rndFile.readInt();
        if (this.recLength != n) {
            throw new SQLException("Internal error header recLength=" + n + "\nComputed record length should be " + this.recLength + "\nTable: " + this.tableName);
        }
        this.bytesOut = new byte[this.recLength];
        this.dataOut = new idbDataOutputStream(this.bytesOut, 2 * this.columnList.size());
        this.rowInputBuffer = new byte[this.rowCacheSize * this.recLength];
        this.firstRowPosn = this.rndFile.getFilePointer();
        if (Trace.traceIt(8)) {
            Trace.traceOut("    Rows " + this.rowCount + " Deleted rows " + this.deletedRowCount);
        }
        if (Trace.traceIt(8)) {
            Trace.traceOut("    Rec len " + this.recLength + " Cols " + this.columnList.size() + " Indexes " + this.indexTables.size());
        }
        if (this.recovered) {
            this.recover();
            if (Trace.traceIt(8)) {
                Trace.traceOut("    Rows " + this.rowCount + " Deleted rows " + this.deletedRowCount);
            }
            if (Trace.traceIt(8)) {
                Trace.traceOut("    Rec len " + this.recLength + " Cols " + this.columnList.size() + " Indexes " + this.indexTables.size());
            }
        }
        if (this.tableType != 2) {
            this.findFirstDeletedRow(1);
        }
        this.dbase.addTable(this);
        return true;
    }

    void recover() throws SQLException {
        long l;
        Vector vector;
        Column[] columnArray;
        block13: {
            if (Trace.traceIt(8)) {
                Trace.traceOut("Recovering table: " + this.tableName);
            }
            this.deletedRowCount = 0;
            this.rowCount = 0;
            columnArray = new Column[this.columnList.size()];
            int n = 0;
            while (n < this.columnList.size()) {
                Column column = (Column)this.columnList.elementAt(n);
                if (column.requiresRecovery) {
                    columnArray[n] = column;
                }
                ++n;
            }
            vector = new Vector(this.getColCount());
            l = 0L;
            try {
                l = this.rndFile.length();
            }
            catch (Exception exception) {
                if (!Trace.traceIt(8)) break block13;
                Trace.traceOut("IO problem getting file length" + exception.toString());
            }
        }
        while (true) {
            block14: {
                try {
                    if (this.rndFile.length() > l) {
                        if (Trace.traceIt(4)) {
                            Trace.traceOut("Had to add new EOF marker " + this.tableName + " may contain invalid data.");
                        }
                        this.rndFile.seek(this.rndFile.length());
                        byte[] byArray = new byte[this.recLength];
                        byArray[0] = -1;
                        this.rndFile.write(byArray, 0, this.recLength);
                    }
                }
                catch (Exception exception) {
                    if (!Trace.traceIt(4)) break block14;
                    Trace.traceOut("IO problem adding EOF marker" + exception.toString());
                }
            }
            ++this.rowCount;
            this.getRow(this.rowCount, vector);
            int n = (Integer)vector.elementAt(0);
            if (n == -1) break;
            if ((n & 1) > 0) {
                ++this.deletedRowCount;
            }
            int n2 = 0;
            while (n2 < columnArray.length) {
                if (columnArray[n2] != null) {
                    columnArray[n2].recover(vector.elementAt(n2));
                }
                ++n2;
            }
            if (this.rowCount % 100 != 0 || !Trace.traceIt(32)) continue;
            Trace.traceOut(this.rowCount + " rows recovered");
        }
        --this.rowCount;
        this.saveRowCounts();
    }

    void addColumn(Column column) {
        column.setOffset(this.recLength);
        this.recLength += column.getLength();
        this.columnList.addElement(column);
    }

    void newColAdded() throws SQLException, IOException {
        Object object;
        Column column = (Column)this.columnList.lastElement();
        this.recLength -= column.getLength();
        Table table = new Table(this.dbase.getTmpFile(), this.dbase, null, this.partitionNumber);
        table.tableName = this.tableName;
        Integer[] integerArray = new Integer[this.columnList.size()];
        int n = 1;
        while (n < this.columnList.size()) {
            object = (Column)this.columnList.elementAt(n);
            table.addColumn((Column)object);
            ((Column)object).cTable = table;
            integerArray[n] = ((Column)object).colID;
            ++n;
        }
        String string = "DELETE FROM " + this.dbase.colsTableName + " WHERE TableId = " + this.tblID;
        object = "DELETE FROM " + this.dbase.tblsTableName + " WHERE TableId = " + this.tblID;
        this.dbase.execSQL(string, null);
        this.dbase.execSQL((String)object, null);
        this.dbase.removeTable(this);
        table.allColumnsAdded(null, false);
        String string2 = "UPDATE " + this.dbase.indxTableName + " SET ColID = ? WHERE ColID = ?";
        SQLProg sQLProg = new SQLProg(this.dbase, string2, true, null);
        int n2 = 1;
        while (n2 < this.columnList.size() - 1) {
            Column column2 = (Column)this.columnList.elementAt(n2);
            sQLProg.setParam(1, column2.colID);
            sQLProg.setParam(2, integerArray[n2]);
            sQLProg.execute();
            ++n2;
        }
        table.rndFile.seek(table.firstRowPosn);
        n2 = 1;
        while (n2 <= this.rowCount) {
            int n3 = this.readRow(n2, 0);
            System.arraycopy(this.rowInputBuffer, n3, table.bytesOut, 0, this.recLength);
            table.dataOut.reset();
            table.dataOut.count = this.recLength;
            table.dataOut.curCol = this.columnList.size() - 1;
            column.setRow(table.dataOut, n2, column.getDefault(), null);
            table.rndFile.write(table.bytesOut);
            this.freeReadAhead();
            ++n2;
        }
        table.rndFile.write(-1);
        table.rowCount = this.rowCount;
        table.deletedRowCount = this.deletedRowCount;
        table.findFirstDeletedRow(1);
        table.indexTables = this.indexTables;
        table.triggers = this.triggers;
        this.rndFile.close();
        if (!this.fileDesc.delete()) {
            throw new SQLException("Error deleting file: " + this.fileDesc);
        }
        table.rndFile.close();
        if (!table.fileDesc.renameTo(this.fileDesc)) {
            throw new SQLException("Error renaming file: " + table.fileDesc + " to " + this.fileDesc);
        }
        table.fileDesc = this.fileDesc;
        table.rndFile = new RandomAccessFile(table.fileDesc, "rw");
        table.fd = table.rndFile.getFD();
        table.markDirty();
        if (this.encryptor != null) {
            this.setTableEncryption(this.encryptor);
        }
    }

    void dropColumn(String string, Column column) throws SQLException, IOException {
        int n;
        int n2 = 0;
        while (n2 < this.indexTables.size()) {
            indexTable indexTable2 = (indexTable)this.indexTables.elementAt(n2);
            Vector vector = indexTable2.indexedCols;
            n = 0;
            while (n < vector.size()) {
                Column column2 = (Column)vector.elementAt(n);
                if (column == column2) {
                    throw new SQLException("Col " + column2.getName() + " is part of index " + indexTable2.getTableName());
                }
                ++n;
            }
            ++n2;
        }
        n2 = column.getLength();
        int n3 = column.getOffset();
        int n4 = n3 + n2;
        n = this.recLength - n2;
        int n5 = this.recLength - n3 - n2;
        long l = 0L;
        String string2 = "DELETE FROM " + this.dbase.colsTableName + " WHERE ColId = " + column.getColID();
        this.dbase.execSQL(string2, null);
        string2 = "UPDATE " + this.dbase.colsTableName + " SET offset = offset - " + n2 + " WHERE TableID = " + this.tblID + " AND offset > " + n3;
        this.dbase.execSQL(string2, null);
        int n6 = 0;
        int n7 = 0;
        while (n7 < this.columnList.size()) {
            Column column3 = (Column)this.columnList.elementAt(n7);
            if (column == column3) {
                n6 = n7;
            } else if (column3.getOffset() > n3) {
                column3.setOffset(column3.getOffset() - n2);
                if (l == 0L) {
                    l = column3.headerPosn - column.headerPosn;
                }
                column3.headerPosn -= l;
            }
            column3.close(this.rndFile);
            ++n7;
        }
        if (l == 0L) {
            l = this.rndFile.getFilePointer() - column.headerPosn;
        }
        this.columnList.removeElementAt(n6);
        n7 = 0;
        int n8 = 1;
        while (n8 <= this.rowCount) {
            int n9 = this.readRow(n8, 0);
            System.arraycopy(this.rowInputBuffer, n9, this.rowInputBuffer, n7, n3);
            System.arraycopy(this.rowInputBuffer, n9 + n4, this.rowInputBuffer, n7 + n3, n5);
            n7 += n;
            if (n8 == this.firstRowCached + this.cachedRowCount - 1) {
                this.rndFile.seek(this.firstRowPosn - l + (long)((this.firstRowCached - 1) * n));
                this.rndFile.write(this.rowInputBuffer, 0, this.cachedRowCount * n);
                n7 = 0;
            }
            this.freeReadAhead();
            ++n8;
        }
        this.rndFile.write(-1);
        this.recLength = n;
        this.firstRowPosn -= l;
        this.rndFile.seek(this.firstRowPosn - 4L);
        this.rndFile.writeInt(n);
        if (this.encryptor != null) {
            this.setTableEncryption(this.encryptor);
        }
    }

    void registerTable(Transaction transaction) throws SQLException {
        if (this.dbase.colTable == null) {
            return;
        }
        if (this.tableType == 3) {
            return;
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(20);
        hashtable.put("TableName", this.tableName);
        hashtable.put("Path", Integer.toString(this.partitionNumber));
        hashtable.put("RecLen", new Integer(this.recLength));
        hashtable.put("Type", new Integer(this.tableType));
        int n = this.dbase.tblTable.addRow(hashtable, transaction);
        this.tblID = (Integer)this.dbase.tblTable.getColByRow("TableID", n);
        int n2 = 0;
        while (n2 < this.columnList.size()) {
            hashtable.clear();
            Column column = (Column)this.columnList.elementAt(n2);
            hashtable.put("TableId", this.tblID);
            hashtable.put("ColName", column.colName);
            hashtable.put("Type", new Integer(column.type));
            hashtable.put("Offset", new Integer(column.recOffset));
            hashtable.put("Length", new Integer(column.colLength));
            RowRangeCache rowRangeCache = (RowRangeCache)column.rowCache;
            hashtable.put("CacheCond", new Integer(rowRangeCache.cacheCondition));
            hashtable.put("CacheAmnt", new Integer(rowRangeCache.cacheAmount));
            if (column.defaultValue != null) {
                hashtable.put("ColDefault", column.defaultValue.toString());
            }
            StringBuffer stringBuffer = new StringBuffer();
            if (column.isPrimaryKey) {
                stringBuffer.append(".PK");
            }
            if (column.unique) {
                stringBuffer.append(".UNIQ");
            }
            if (column.notNull) {
                stringBuffer.append(".~NULL");
            }
            hashtable.put("Flags", stringBuffer.toString());
            n = this.dbase.colTable.addRow(hashtable, transaction);
            column.colID = (Integer)this.dbase.colTable.getColByRow("ColID", n);
            ++n2;
        }
        try {
            this.dbase.colTable.fd.sync();
            this.dbase.tblTable.fd.sync();
            this.fd.sync();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    void allColumnsAdded(Transaction transaction, boolean bl) throws IOException, SQLException {
        this.bytesOut = new byte[this.recLength];
        this.dataOut = new idbDataOutputStream(this.bytesOut, 2 * this.columnList.size());
        this.rowInputBuffer = new byte[this.rowCacheSize * this.recLength];
        if (this.addToTableList) {
            this.dbase.addTable(this);
        }
        if (this.dbase.readOnly) {
            return;
        }
        if (this.rndFile == null) {
            return;
        }
        if (this.tableType != 3) {
            this.dbase.addTable(this);
        }
        Vector<String> vector = new Vector<String>(this.columnList.size());
        Object object = this.columnList.elements();
        while (object.hasMoreElements()) {
            Column column = (Column)object.nextElement();
            column.write(this.rndFile);
            if (!column.inPrimaryKey() || !bl) continue;
            vector.addElement(column.getName());
        }
        this.rndFile.writeInt(this.recLength);
        this.firstRowPosn = this.rndFile.getFilePointer();
        object = new byte[this.recLength];
        int n = 0;
        while (n < this.recLength) {
            object[n] = -1;
            ++n;
        }
        this.rndFile.write((byte[])object, 0, this.recLength);
        if (this.fd != null) {
            this.fd.sync();
        }
        this.registerTable(transaction);
        if (!vector.isEmpty()) {
            new indexTable(this, vector, this.tableName + "$pKey", false, transaction, this.partitionNumber);
        }
        if (this.tableType == 2) {
            try {
                if (this.tblID != null && (n = this.tblID.intValue()) >= 1006) {
                    this.rndFile.close();
                    this.rndFile = null;
                    this.fd = null;
                }
            }
            catch (IOException iOException) {
                throw new SQLException("IO problem closing index file: " + iOException);
            }
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public int getColCount() {
        return this.columnList.size();
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getValidRowCount() {
        return this.rowCount - this.deletedRowCount;
    }

    public Vector getColList() {
        return this.columnList;
    }

    public int getTableID() {
        if (this.tblID == null) {
            return 0;
        }
        return this.tblID;
    }

    public boolean checkColName(String string) {
        int n = 0;
        while (n < this.columnList.size()) {
            Column column = (Column)this.columnList.elementAt(n);
            if (column.getName().equalsIgnoreCase(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public Column getColByName(String string) {
        int n = 0;
        while (n < this.columnList.size()) {
            Column column = (Column)this.columnList.elementAt(n);
            if (column.getName().equalsIgnoreCase(string)) {
                return column;
            }
            ++n;
        }
        return null;
    }

    public int getColIndex(String string) {
        int n = 0;
        while (n < this.columnList.size()) {
            Column column = (Column)this.columnList.elementAt(n);
            if (column.getName().equalsIgnoreCase(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Column getColByName(String string, boolean bl) {
        boolean bl2 = false;
        int n = string.indexOf(46);
        if (n != -1) {
            bl2 = true;
        }
        int n2 = 0;
        while (n2 < this.columnList.size()) {
            Column column = (Column)this.columnList.elementAt(n2);
            String string2 = column.getName();
            if (bl2) {
                Table table = column.getUnderlyingTable();
                if (table != null) {
                    String string3 = table.getTableName();
                    string2 = string3 + "." + string2;
                } else {
                    string2 = this.tableName + "." + string2;
                }
            }
            if (string2.equalsIgnoreCase(string)) {
                return column;
            }
            if (bl && (n = string2.indexOf(46)) != -1) {
                string2 = string2.substring(n + 1);
            }
            if (string2.equalsIgnoreCase(string)) {
                return column;
            }
            ++n2;
        }
        return null;
    }

    public Column getColByID(Integer n) {
        int n2 = 0;
        while (n2 < this.columnList.size()) {
            Column column = (Column)this.columnList.elementAt(n2);
            if (column.colID.equals(n)) {
                return column;
            }
            ++n2;
        }
        return null;
    }

    public Object getColByRow(String string, int n) throws SQLException {
        Column column = this.getColByName(string);
        if (column == null) {
            return null;
        }
        return column.getByRow(n);
    }

    void gc() {
        long l;
        long l2;
        boolean bl = false;
        if (++accessCount % 100 == 0 && (l2 = (l = this.runTime.totalMemory()) - this.runTime.freeMemory()) > 3L * l / 4L && !this.dbase.microsoftVM) {
            bl = true;
        }
        if (accessCount > 1000) {
            bl = true;
        }
        if (bl) {
            accessCount = 0;
            if (Trace.traceIt(128)) {
                Trace.traceOut("Requesting gc");
            }
            this.dbase.traceMemory();
            this.dbase.traceMemory();
        }
    }

    public void getRowByValue(String string, Object object, Vector vector) throws SQLException {
        Column column = this.getColByName(string);
        int n = column.getRowByValue(object, 0);
        if (n == 0) {
            return;
        }
        this.getRow(n, vector);
    }

    public Object getValueByValue(String string, Object object, Column column) throws SQLException {
        Vector vector = new Vector(this.getColCount());
        this.getRowByValue(string, object, vector);
        if (vector == null) {
            return null;
        }
        int n = 0;
        while (n < this.columnList.size()) {
            if (this.columnList.elementAt(n) == column) {
                return vector.elementAt(n);
            }
            ++n;
        }
        return null;
    }

    public int getRelColPosn(String string) {
        int n = 0;
        while (n < this.columnList.size()) {
            Column column = (Column)this.columnList.elementAt(n);
            if (column.getName().equalsIgnoreCase(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void getRow(int n, Vector vector) throws SQLException {
        int n2 = this.columnList.size();
        vector.removeAllElements();
        if (this.order != null) {
            n = this.order[n - 1] + 1;
        }
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            Column column = (Column)this.columnList.elementAt(n3);
            Object object = column.getByRow(n);
            vector.addElement(object);
            if (n3 == 0 && (n4 = ((Integer)object).intValue()) == -1) break;
            ++n3;
        }
    }

    public void exportText(String string) throws SQLException {
        Trace trace = Trace.getTrace();
        if (trace.export == null) {
            return;
        }
        if ((trace.getTraceLevel() & 0x800) == 0) {
            return;
        }
        PrintWriter printWriter = trace.export;
        synchronized (printWriter) {
            int n;
            PrintWriter printWriter2 = trace.export;
            if (string != null) {
                printWriter2.println(string);
            }
            if (trace.printSummaryHeader && this.tableType != 3) {
                printWriter2.println("Table " + this.tableName + " has " + this.rowCount + " rows. " + this.deletedRowCount + " are deleted.");
            }
            StringBuffer stringBuffer = new StringBuffer(1024);
            int n2 = this.columnList.size();
            Column[] columnArray = new Column[n2];
            int[] nArray = new int[n2];
            if (trace.colHeaders && trace.printRowNumbers) {
                stringBuffer.append("Row  ");
            }
            int n3 = 0;
            while (n3 < n2) {
                if (n3 != 0 || trace.printControlCol) {
                    Object object;
                    columnArray[n3] = (Column)this.columnList.elementAt(n3);
                    n = 0;
                    switch (columnArray[n3].type) {
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            n = 9;
                            break;
                        }
                        case 8: {
                            n = 15;
                            break;
                        }
                        case 3: {
                            object = (StringColumn)columnArray[n3];
                            n = ((StringColumn)object).maxSize + 1;
                            break;
                        }
                        default: {
                            n = 5;
                        }
                    }
                    if (trace.colHeaders) {
                        object = columnArray[n3].getName() + ' ';
                        nArray[n3] = ((String)object).length();
                        stringBuffer.append((String)object);
                        if (nArray[n3] < n) {
                            int n4 = nArray[n3];
                            while (n4 < n) {
                                stringBuffer.append(' ');
                                ++n4;
                            }
                            nArray[n3] = n;
                        }
                    } else {
                        nArray[n3] = n;
                    }
                }
                ++n3;
            }
            if (trace.colHeaders) {
                printWriter2.println(stringBuffer);
            }
            Vector vector = new Vector(n2);
            n = 1;
            while (n <= this.rowCount) {
                stringBuffer.setLength(0);
                if (!this.rowDeleted(n) || trace.printDelRows) {
                    if (trace.printRowNumbers) {
                        stringBuffer.append(n);
                        if (!trace.csvDelimited) {
                            if (n < 10) {
                                stringBuffer.append(' ');
                            }
                            if (n < 100) {
                                stringBuffer.append(' ');
                            }
                            if (n < 1000) {
                                stringBuffer.append(' ');
                            }
                            if (n < 10000) {
                                stringBuffer.append(' ');
                            }
                        } else {
                            stringBuffer.append(trace.delimiter);
                        }
                    }
                    this.getRow(n, vector);
                    int n5 = 0;
                    while (n5 < n2) {
                        if (n5 != 0 || trace.printControlCol) {
                            Object e = vector.elementAt(n5);
                            String string2 = columnArray[n5].toString(e);
                            trace.appendQuote(stringBuffer);
                            stringBuffer.append(string2);
                            trace.appendQuote(stringBuffer);
                            if (trace.csvDelimited) {
                                if (n5 != n2 - 1) {
                                    stringBuffer.append(trace.delimiter);
                                }
                            } else if (string2.length() < nArray[n5]) {
                                int n6 = string2.length();
                                while (n6 < nArray[n5]) {
                                    stringBuffer.append(' ');
                                    ++n6;
                                }
                            } else {
                                stringBuffer.append(' ');
                                nArray[n5] = string2.length() + 1;
                            }
                        }
                        ++n5;
                    }
                    printWriter2.println(stringBuffer);
                }
                ++n;
            }
            trace.export.flush();
        }
    }

    boolean rowDeleted(int n) throws SQLException {
        if (this.deletedRowCount == 0) {
            return false;
        }
        if (this.order != null) {
            n = this.order[n - 1] + 1;
        }
        return this.controlCol.deleteBitSet(n);
    }

    int findFirstDeletedRow(int n) throws SQLException {
        if (this.deletedRowCount == 0) {
            this.firstDeletedRow = 0;
            return this.firstDeletedRow;
        }
        int n2 = n;
        while (n2 <= this.rowCount) {
            if (this.rowDeleted(n2)) {
                this.firstDeletedRow = n2;
                return this.firstDeletedRow;
            }
            ++n2;
        }
        n2 = 1;
        while (n2 < n) {
            if (this.rowDeleted(n2)) {
                if (n2 == this.firstDeletedRow) break;
                this.firstDeletedRow = n2;
                return this.firstDeletedRow;
            }
            ++n2;
        }
        this.firstDeletedRow = 0;
        this.deletedRowCount = 0;
        if (!this.modified) {
            this.markDirty();
        }
        return this.firstDeletedRow;
    }

    void createWriteBuffer(int n) {
        this.writeBufferSize = n * this.recLength;
        this.writeBuffer = new byte[this.writeBufferSize];
        this.writeBufferOffset = 0;
        this.writeBufferRow = 0;
        this.bytesIn = new ByteArrayInputStream(this.writeBuffer);
        this.dataIn = new DataInputStream(this.bytesIn);
    }

    void writeWriteBuffer(boolean bl) throws IOException {
        if (this.writeBufferOffset != 0) {
            long l = this.firstRowPosn + (long)((this.writeBufferRow - 1) * this.recLength);
            this.rndFile.seek(l);
            this.rndFile.write(this.writeBuffer, 0, this.writeBufferOffset);
            this.writeBufferOffset = 0;
            byte by = this.bytesOut[0];
            this.bytesOut[0] = -1;
            this.rndFile.write(this.bytesOut, 0, this.recLength);
            if (this.fd != null) {
                this.fd.sync();
            }
            this.bytesOut[0] = by;
        }
        if (bl) {
            this.writeBuffer = null;
            this.cachedRowCount = 0;
        }
    }

    void addRowAtRow(Vector vector, int n, Transaction transaction) throws SQLException {
        int n2;
        int n3;
        boolean bl = false;
        if (n <= this.rowCount && this.rowDeleted(n)) {
            bl = true;
        }
        try {
            this.dataOut.reset();
            n3 = 0;
            while (n3 < this.columnList.size()) {
                Column column = (Column)this.columnList.elementAt(n3);
                Object e = vector.elementAt(n3);
                column.setRow(this.dataOut, n, e, transaction);
                ++n3;
            }
        }
        catch (Exception exception) {
            if (bl) {
                Column column = (Column)this.columnList.elementAt(0);
                Integer n4 = ByteColumn.getInteger(1);
                column.rowCache.add(n4, n);
            }
            throw new SQLException(exception.toString());
        }
        if (this.dbase.readOnly) {
            if (this.tableType != 3) {
                throw new SQLException("Error writing to table, " + this.tableName + " - database is readonly.");
            }
            ++this.rowCount;
            return;
        }
        if (this.tableType == 3 && !this.dbase.resultsOnDisk) {
            if (bl) {
                --this.deletedRowCount;
                if (n == this.firstDeletedRow) {
                    this.findFirstDeletedRow(n + 1);
                }
            } else if (n > this.rowCount) {
                ++this.rowCount;
            }
            return;
        }
        if (this.encryptor != null) {
            n3 = this.bytesOut[0];
            this.encryptor.Encrypt(this.tableName, this.bytesOut, n, this.colOffsets);
            this.bytesOut[0] = n3;
            if (n == this.lastDecryptedRow) {
                this.lastDecryptedRow = 0;
            }
            this.dataOut.cache = null;
            this.saveRowCounts();
        }
        try {
            if (!this.modified) {
                this.markDirty();
            }
            this.transModified = true;
            if (transaction != null && this.tableType != 3) {
                this.journal.writeTransactionRecord(transaction, 1231975028, n, this, null, this.bytesOut);
            }
            if (bl) {
                --this.deletedRowCount;
                if (n == this.firstDeletedRow) {
                    this.findFirstDeletedRow(n + 1);
                }
            } else if (n > this.rowCount) {
                ++this.rowCount;
            }
            if (this.writeBuffer != null) {
                if (this.writeBufferOffset == 0) {
                    this.writeBufferRow = n;
                }
                System.arraycopy(this.bytesOut, 0, this.writeBuffer, this.writeBufferOffset, this.recLength);
                this.writeBufferOffset += this.recLength;
                if (this.writeBufferOffset == this.writeBufferSize) {
                    this.writeWriteBuffer(false);
                }
            } else {
                long l = this.firstRowPosn + (long)((n - 1) * this.recLength);
                this.rndFile.seek(l);
                this.rndFile.write(this.bytesOut, 0, this.recLength);
                if (n == this.rowCount) {
                    byte by = this.bytesOut[0];
                    this.bytesOut[0] = -1;
                    this.rndFile.write(this.bytesOut, 0, this.recLength);
                    this.bytesOut[0] = by;
                }
            }
            if (n >= this.firstRowCached && n < this.firstRowCached + this.cachedRowCount) {
                int n5 = (n - this.firstRowCached) * this.recLength;
                System.arraycopy(this.bytesOut, 0, this.rowInputBuffer, n5, this.recLength);
            }
            if (this.rowDeleted(n)) {
                ++this.deletedRowCount;
            }
            n2 = 0;
            while (n2 < this.indexTables.size()) {
                indexTable indexTable2 = (indexTable)this.indexTables.elementAt(n2);
                indexTable2.addRowToIndex(n);
                ++n2;
            }
        }
        catch (IOException iOException) {
            throw new SQLException("Disk write problem: " + iOException.toString());
        }
        if (this.triggers != null && transaction != null) {
            Vector vector2 = new Vector(this.columnList.size());
            this.getRow(n, vector2);
            vector2.removeElementAt(0);
            n2 = 0;
            while (n2 < this.triggers.size()) {
                idbTrigger idbTrigger2 = (idbTrigger)this.triggers.elementAt(n2);
                if (this.updating) {
                    if ((idbTrigger2.getEvents() & 1) > 0) {
                        idbTrigger2.onUpdate((Vector)vector2.clone(), transaction.ID);
                    }
                } else if ((idbTrigger2.getEvents() & 4) > 0) {
                    idbTrigger2.onAdd((Vector)vector2.clone(), transaction.ID);
                }
                ++n2;
            }
        }
    }

    int addRow(Object object, Transaction transaction, int n) throws SQLException {
        int n2 = this.addRow(object, transaction);
        if (this.fromTable != null) {
            this.fromTable.add(n);
        }
        return n2;
    }

    public Table getUnderlyingTable() {
        return this.underlyingTable;
    }

    public int getUnderlyingRow(int n) {
        return this.fromTable.array[n - 1];
    }

    public int addRow(Object object, Transaction transaction) throws SQLException {
        int n = 0;
        n = this.rowCount + 1;
        if (this.deletedRowCount > 0) {
            if (this.firstDeletedRow < this.minRowDeleted) {
                n = this.firstDeletedRow;
            } else if (this.dbase.searchDeletes && this.maxRowDeleted != Integer.MAX_VALUE) {
                int n2 = this.maxRowDeleted + 1;
                while (n2 < this.rowCount) {
                    if (this.rowDeleted(n2)) {
                        n = n2;
                    }
                    ++n2;
                }
            }
        }
        if (object instanceof Hashtable) {
            Hashtable hashtable = (Hashtable)object;
            Vector vector = new Vector(this.columnList.size());
            int n3 = 0;
            while (n3 < this.columnList.size()) {
                Column column = (Column)this.columnList.elementAt(n3);
                String string = column.getName();
                Object object2 = hashtable.get(string);
                if (object2 == null || object2 == "NULL") {
                    object2 = column.getDefault();
                }
                vector.addElement(object2);
                ++n3;
            }
            this.addRowAtRow(vector, n, transaction);
        } else {
            this.addRowAtRow((Vector)object, n, transaction);
        }
        return n;
    }

    void addOrderedField(String string, String string2, boolean bl) throws SQLException {
        if (this.orderedFields == null) {
            this.orderedFields = new int[this.columnList.size()];
            this.numOrdered = 0;
        }
        Column column = null;
        int n = 0;
        String string3 = null;
        if (string != null) {
            string3 = string + "." + string2;
        }
        int n2 = 0;
        while (n2 < this.columnList.size()) {
            Column column2 = (Column)this.columnList.elementAt(n2);
            if (string2.equalsIgnoreCase(column2.getName())) {
                column = column2;
                n = n2;
                break;
            }
            if (string != null) {
                if (string3.equalsIgnoreCase(column2.getName())) {
                    column = column2;
                    n = n2;
                    break;
                }
            } else {
                String string4 = column2.getName();
                int n3 = string4.indexOf(46);
                if (n3 >= 0 && string2.equalsIgnoreCase(string4 = string4.substring(n3 + 1))) {
                    if (column != null) {
                        throw new SQLException("Ambiguous column name: " + string2);
                    }
                    column = column2;
                    n = n2;
                }
            }
            ++n2;
        }
        if (column == null) {
            try {
                n = Integer.parseInt(string2);
                column = (Column)this.columnList.elementAt(n);
            }
            catch (Exception exception) {
                throw new SQLException("ORDER BY column, " + string2 + ", must be in the column selection");
            }
        }
        this.orderedFields[this.numOrdered++] = n;
        column.order = 1;
        if (bl) {
            column.order = 2;
        }
    }

    boolean rowEquals(int n, Vector vector) throws SQLException {
        int n2 = 1;
        while (n2 < this.columnList.size()) {
            Column column = (Column)this.columnList.elementAt(n2);
            if (!column.compare(n, vector.elementAt(n2), 1, true)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    void decryptRow(byte[] byArray, int n, int n2, int n3) throws IOException {
        if (this.lastDecryptedRow != n) {
            int n4 = (n - n2) * this.recLength;
            System.arraycopy(byArray, n4, this.encryptBuffer, 0, this.recLength);
            byte by = this.encryptBuffer[0];
            this.encryptor.Decrypt(this.tableName, this.encryptBuffer, n, this.colOffsets);
            this.encryptBuffer[0] = by;
            this.bytesIn = new ByteArrayInputStream(this.encryptBuffer);
            this.dataIn = new DataInputStream(this.bytesIn);
            this.lastDecryptedRow = n;
        }
        this.dataIn.reset();
        this.dataIn.skip(n3);
    }

    void freeReadAhead() {
        this.readAheadLocked = false;
        byte[] byArray = this.rowInputBuffer;
        synchronized (byArray) {
            this.rowInputBuffer.notify();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int readRow(int n, int n2) throws IOException {
        int n3 = 0;
        if (this.writeBuffer != null) {
            this.bytesIn.reset();
            n3 = (n - this.writeBufferRow) * this.recLength + n2;
            this.bytesIn.skip(n3);
            if (this.encryptor != null) {
                this.decryptRow(this.writeBuffer, n, this.writeBufferRow, n2);
            }
            return n2;
        }
        byte[] byArray = this.rowInputBuffer;
        synchronized (byArray) {
            while (true) {
                if (!this.readAheadLocked) {
                    this.readAheadLocked = true;
                    break;
                }
                try {
                    this.rowInputBuffer.wait();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
        if (n < this.firstRowCached || n >= this.firstRowCached + this.cachedRowCount) {
            this.cachedRowCount = n == this.firstRowCached + this.cachedRowCount && this.cachedRowCount != 0 ? (n + this.rowCacheSize > this.rowCount + 1 ? this.rowCount - n + 1 : this.rowCacheSize) : 1;
            this.firstRowCached = n;
            this.rndFile.seek(this.firstRowPosn + (long)((this.firstRowCached - 1) * this.recLength));
            this.rndFile.read(this.rowInputBuffer, 0, this.cachedRowCount * this.recLength);
            this.bytesIn = new ByteArrayInputStream(this.rowInputBuffer);
            this.dataIn = new DataInputStream(this.bytesIn);
        }
        this.bytesIn.reset();
        n3 = (n - this.firstRowCached) * this.recLength + n2;
        this.bytesIn.skip(n3);
        if (this.encryptor != null) {
            this.decryptRow(this.rowInputBuffer, n, this.firstRowCached, n2);
        }
        return n3;
    }

    public void deleteRow(int n, Transaction transaction) throws SQLException {
        if (n > this.rowCount && transaction == null) {
            return;
        }
        if (n == this.lastDecryptedRow) {
            this.lastDecryptedRow = 0;
        }
        if (this.maxRowDeleted == 0) {
            this.minRowDeleted = this.maxRowDeleted = n;
        } else if (n > this.maxRowDeleted) {
            this.prevMax = this.maxRowDeleted;
            if (this.prevMax == 0) {
                this.prevMax = Integer.MAX_VALUE;
            }
            this.maxRowDeleted = n;
        } else if (n < this.minRowDeleted) {
            this.minRowDeleted = n;
        }
        if (n <= 256) {
            this.delRows.set(n - 1);
        }
        if (transaction != null) {
            this.journal.writeTransactionRecord(transaction, 1147497588, n, this, null, null);
        }
        int n2 = 0;
        while (n2 < this.indexTables.size()) {
            indexTable indexTable2 = (indexTable)this.indexTables.elementAt(n2);
            indexTable2.delRowFromIndex(n);
            ++n2;
        }
        ++this.deletedRowCount;
        if (n < this.firstDeletedRow || this.deletedRowCount == 1) {
            this.firstDeletedRow = n;
        }
        n2 = 0;
        while (n2 < this.columnList.size()) {
            Column column = (Column)this.columnList.elementAt(n2);
            column.onDelete(this.rndFile, n, transaction);
            ++n2;
        }
        this.dataOut.reset();
        this.controlCol.setRow(this.dataOut, n, rowdel, transaction);
        try {
            if (!this.modified) {
                this.markDirty();
            }
            this.transModified = true;
            if (this.rndFile != null) {
                this.rndFile.seek(this.firstRowPosn + (long)((n - 1) * this.recLength) + (long)this.controlCol.getOffset());
                this.rndFile.write(this.bytesOut, 0, this.controlCol.getLength());
            }
            if (this.encryptor != null) {
                this.saveRowCounts();
            }
        }
        catch (Exception exception) {
            throw new SQLException("IO problem while deleting row: " + n + " " + exception.toString());
        }
        if (n >= this.firstRowCached && n < this.firstRowCached + this.cachedRowCount) {
            this.cachedRowCount = n - this.firstRowCached;
        }
        if (this.triggers != null && transaction != null) {
            Vector vector = new Vector(this.columnList.size());
            this.getRow(n, vector);
            vector.removeElementAt(0);
            int n3 = 0;
            while (n3 < this.triggers.size()) {
                idbTrigger idbTrigger2 = (idbTrigger)this.triggers.elementAt(n3);
                if ((idbTrigger2.getEvents() & 2) > 0 && !this.updating) {
                    idbTrigger2.onDelete((Vector)vector.clone(), transaction.ID);
                }
                if ((idbTrigger2.getEvents() & 1) > 0 && this.updating) {
                    idbTrigger2.preUpdate((Vector)vector.clone(), transaction.ID);
                }
                ++n3;
            }
        }
    }

    indexTable getIndex(Vector vector) {
        int n = 0;
        while (n < this.indexTables.size()) {
            indexTable indexTable2 = (indexTable)this.indexTables.elementAt(n);
            if (indexTable2.indexes(vector)) {
                return indexTable2;
            }
            ++n;
        }
        return null;
    }

    indexTable getIndex(Column column) {
        Vector<Column> vector = new Vector<Column>(1);
        vector.addElement(column);
        return this.getIndex(vector);
    }

    Vector getAllIndexes(Column column) {
        Vector<Column> vector = new Vector<Column>(1);
        vector.addElement(column);
        Vector<indexTable> vector2 = new Vector<indexTable>(5);
        int n = 0;
        while (n < this.indexTables.size()) {
            indexTable indexTable2 = (indexTable)this.indexTables.elementAt(n);
            if (indexTable2.indexes(vector)) {
                vector2.addElement(indexTable2);
            }
            ++n;
        }
        return vector2;
    }

    /*
     * Unable to fully structure code
     */
    synchronized void lockTable(Transaction var1_1) throws SQLException {
        if (var1_1 == null) {
            return;
        }
        if (var1_1.obeysLocks()) ** GOTO lbl18
        return;
lbl-1000:
        // 1 sources

        {
            if (var1_1.getLockCount() > 0 && this.lockOwner.checkDeadLock(var1_1)) {
                throw new SQLException("Deadlock detected by\n" + var1_1.toString() + "\nTrying to lock table: " + this.tableName + "\nLock owner: \n" + this.lockOwner.toString());
            }
            var1_1.setWaitTransaction(this.lockOwner);
            if (Trace.traceIt(16)) {
                Trace.traceOut("Transaction: " + this.lockOwner.ID + " has " + this.lockCount + " lock(s) on table: " + this.tableName + ". " + var1_1.ID + " Waiting...");
            }
            try {
                var1_1.waitThread = Thread.currentThread();
                this.wait();
                if (!this.dbase.isValid()) {
                    throw new SQLException("Database closed while waiting for table");
                }
                continue;
            }
            catch (InterruptedException var2_2) {
                throw new SQLException("Timeout detected by\n" + var1_1.toString() + "\nTrying to lock table: " + this.tableName + "\nLock owner: \n" + this.lockOwner.toString());
            }
lbl18:
            // 2 sources

            ** while (this.lockCount > 0 && this.lockOwner != var1_1)
        }
lbl19:
        // 1 sources

        var1_1.setWaitTransaction(null);
        if (this.lockCount > 0) {
            ** if (this.ownerThread == Thread.currentThread()) goto lbl28
        }
        this.ownerThread = Thread.currentThread();
        this.minRowDeleted = 0x7FFFFFFF;
        this.maxRowDeleted = 0;
        this.prevMax = 0x7FFFFFFF;
        this.delRows.xor(this.delRows);
lbl-1000:
        // 1 sources

        {
            // empty if block
        }
lbl28:
        // 3 sources

        this.lockOwner = var1_1;
        ++this.lockCount;
        var1_1.addLock(this);
        if (Trace.traceIt(16)) {
            Trace.traceOut("Trans " + var1_1.ID + " locked table: " + this.tableName + " Lock count=" + this.lockCount);
        }
    }

    synchronized void freeTable() throws SQLException {
        --this.lockCount;
        try {
            if (this.fd != null && this.transModified && this.lockCount == 0) {
                if (this.fd.valid() && !this.fastUpdate) {
                    this.fd.sync();
                }
                this.transModified = false;
            }
        }
        catch (Exception exception) {
            System.out.println("Table " + this.tableName);
            exception.printStackTrace();
        }
        if (Trace.traceIt(16)) {
            Trace.traceOut("Trans " + this.lockOwner.ID + " freed  table: " + this.tableName + " Lock count=" + this.lockCount);
        }
        if (this.lockCount < 0) {
            throw new SQLException("Internal error - Transaction: " + this.lockOwner.ID + " has " + this.lockCount + " lock(s) on table: " + this.tableName);
        }
        if (this.lockCount == 0) {
            this.notify();
        }
    }

    public synchronized void dropTable(Transaction transaction) throws SQLException {
        if (this.isClosed) {
            return;
        }
        if (Trace.traceIt(8)) {
            Trace.traceOut("Dropping table " + this.tableName);
        }
        this.dbase.removeTable(this);
        while (!this.indexTables.isEmpty()) {
            indexTable indexTable2 = (indexTable)this.indexTables.elementAt(0);
            indexTable2.dropTable(transaction);
        }
        try {
            int n = 0;
            while (n < this.columnList.size()) {
                Column column = (Column)this.columnList.elementAt(n);
                column.onDrop();
                ++n;
            }
            this.close(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.tableType != 3) {
            Table table = this.dbase.colTable;
            int n = 1;
            while (n <= table.rowCount) {
                Integer n2 = (Integer)table.getColByRow("TableID", n);
                if (this.tblID.equals(n2)) {
                    table.deleteRow(n, transaction);
                }
                ++n;
            }
            Table table2 = this.dbase.tblTable;
            int n3 = 1;
            while (n3 <= table2.rowCount) {
                Integer n4 = (Integer)table2.getColByRow("TableID", n3);
                if (this.tblID.equals(n4)) {
                    table2.deleteRow(n3, transaction);
                    break;
                }
                ++n3;
            }
        }
        this.rowInputBuffer = null;
        try {
            if (this.tableType != 3) {
                this.dbase.colTable.fd.sync();
                this.dbase.tblTable.fd.sync();
                this.dbase.idxTable.fd.sync();
            }
            this.fileDesc.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        if (this.tableType == 3 && this.indexTables != null) {
            this.dropTable(null);
        }
        if (this.addToTableList) {
            this.dbase.removeTable(this);
        }
    }

    void addTrigger(idbTrigger idbTrigger2) throws SQLException {
        if (this == this.dbase.tblTable || this == this.dbase.colTable || this == this.dbase.idxTable) {
            throw new SQLException("Triggers not allowed on system tables");
        }
        if (this.triggers == null) {
            this.triggers = new Vector(10, 10);
        }
        this.triggers.addElement(idbTrigger2);
    }

    void rollbackTriggers(long l) {
        if (this.triggers != null) {
            int n = 0;
            while (n < this.triggers.size()) {
                idbTrigger idbTrigger2 = (idbTrigger)this.triggers.elementAt(n);
                if ((idbTrigger2.getEvents() & 8) > 0) {
                    idbTrigger2.onRollback(l);
                }
                ++n;
            }
        }
    }

    void commitTriggers(long l) {
        if (this.triggers != null) {
            int n = 0;
            while (n < this.triggers.size()) {
                idbTrigger idbTrigger2 = (idbTrigger)this.triggers.elementAt(n);
                if ((idbTrigger2.getEvents() & 0x10) > 0) {
                    idbTrigger2.onCommit(l);
                }
                ++n;
            }
        }
    }

    void removeTrigger(idbTrigger idbTrigger2) {
        this.triggers.removeElement(idbTrigger2);
        if (this.triggers.size() == 0) {
            this.triggers = null;
        }
    }

    public boolean lt(int n, int n2) {
        try {
            int n3 = 0;
            while (n3 < this.numOrdered) {
                int n4 = this.orderedFields[n3];
                Column column = (Column)this.columnList.elementAt(n4);
                Object object = column.getByRow(n2 + 1);
                int n5 = 7;
                if (column.order == 2) {
                    n5 = 5;
                }
                if (column.compare(n + 1, object, n5, true)) {
                    return true;
                }
                if (!column.compare(n + 1, object, 1, true)) {
                    return false;
                }
                ++n3;
            }
            return false;
        }
        catch (Exception exception) {
            System.out.println("Error comparing rows during ordering: \n" + exception.getMessage());
            return false;
        }
    }

    public int getCount() {
        this.rowCount -= this.deletedRowCount;
        return this.rowCount;
    }

    public void swap(int n, int n2) {
        try {
            Vector vector = new Vector(this.columnList.size());
            this.getRow(n + 1, vector);
            Vector vector2 = new Vector(this.columnList.size());
            this.getRow(n2 + 1, vector2);
            this.addRowAtRow(vector2, n + 1, null);
            this.addRowAtRow(vector, n2 + 1, null);
            if (this.dbase.readOnly) {
                this.rowCount -= 2;
            }
        }
        catch (Exception exception) {
            System.out.println("Error swapping rows during ordering: \n" + exception.getMessage());
        }
    }

    public void setOrder(int[] nArray) {
        this.order = nArray;
    }

    String rowToString(int n, boolean bl) {
        int n2 = this.columnList.size();
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("Row " + n);
        int n3 = 0;
        while (n3 < n2) {
            if (n3 != 0 || bl) {
                Column column = (Column)this.columnList.elementAt(n3);
                try {
                    Object object = column.getByRow(n);
                    stringBuffer.append(' ');
                    if (object instanceof String) {
                        stringBuffer.append(object.toString());
                    } else {
                        stringBuffer.append(column.toString(object));
                    }
                }
                catch (Exception exception) {
                    System.out.println(exception.toString());
                }
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    void dump(int n) {
        System.out.println(this.rowToString(n, true));
    }

    void dump() {
        int n = 0;
        while (n <= this.rowCount) {
            this.dump(n);
            ++n;
        }
    }

    void setTableEncryption(TableEncrypt tableEncrypt) throws SQLException {
        this.encryptor = tableEncrypt;
        this.encryptBuffer = new byte[this.recLength];
        this.colOffsets = new int[this.columnList.size()];
        int n = 0;
        while (n < this.columnList.size()) {
            Column column = (Column)this.columnList.elementAt(n);
            this.colOffsets[n] = column.getOffset();
            ++n;
        }
    }

    public Table(String string, Database database, Transaction transaction, int n) throws SQLException {
        this.tableType = 1;
        try {
            this.construct(string, database, n);
        }
        catch (IOException iOException) {
            throw new SQLException("IO problem: " + iOException.toString() + iOException.getMessage());
        }
        this.lockTable(transaction);
    }

    Table(String string, Database database, boolean bl, boolean bl2) throws SQLException {
        this.tableType = bl ? 3 : 1;
        if (bl2) {
            this.addToTableList = true;
        }
        try {
            this.construct(string, database, -1);
        }
        catch (IOException iOException) {
            throw new SQLException("IO problem: " + iOException.toString() + iOException.getMessage());
        }
    }

    Table(IdbVector idbVector, Table table, Object object, Hashtable hashtable) throws SQLException {
        Object object2;
        this.runTime = Runtime.getRuntime();
        this.dbase = table.dbase;
        this.journal = this.dbase.journal;
        this.fastUpdate = this.dbase.fastUpdate;
        this.columnList = new Vector(10, 10);
        this.indexTables = new Vector(10, 10);
        this.delRows = new BitSet(256);
        this.rowCacheSize = this.dbase.getIntegerProperty("rowCacheSize", "20");
        if (idbVector == null) {
            this.tableName = (String)object;
            this.tblID = new Integer(1002);
            this.path = this.dbase.tablePath;
            this.tableType = 1;
        } else {
            this.tblID = idbVector.getIntegerAt(1);
            this.tableName = idbVector.getStringAt(2);
            object2 = idbVector.getStringAt(3);
            this.partitionNumber = ((String)object2).length() > 0 ? Integer.parseInt((String)object2) : -1;
            if (this.tblID < 1000) {
                throw new SQLException("Internal error - illegal table ID: " + this.tblID + " column: " + this.tableName);
            }
            if (this.tblID.equals(new Integer(1000))) {
                return;
            }
            if (this.tblID.equals(new Integer(1002))) {
                return;
            }
            this.tableType = idbVector.getIntAt(5);
            this.setTablePath();
        }
        object2 = (Vector)hashtable.get(this.tblID);
        IdbVector idbVector2 = new IdbVector(table);
        int n = 0;
        while (n < ((Vector)object2).size()) {
            int[] nArray = (int[])((Vector)object2).elementAt(n);
            table.getRow(nArray[0], idbVector2);
            int n2 = idbVector2.getIntAt(1);
            String string = idbVector2.getStringAt(3);
            String string2 = idbVector2.getStringAt(4);
            int n3 = idbVector2.getIntAt(5);
            int n4 = idbVector2.getIntAt(6);
            int n5 = idbVector2.getIntAt(7);
            int n6 = idbVector2.getIntAt(8);
            int n7 = idbVector2.getIntAt(9);
            String string3 = idbVector2.getStringAt(10);
            if (n2 < 1000) {
                throw new SQLException("Internal error - illegal column ID: " + n2 + " column: " + string);
            }
            Column column = null;
            switch (n3) {
                case 3: {
                    column = new StringColumn(this, string, (n5 - 4) / 2);
                    break;
                }
                case 11: {
                    column = new Char1Column(this, string, n5 - 4);
                    break;
                }
                case 2: {
                    column = new IntegerColumn(this, string);
                    break;
                }
                case 4: {
                    column = new LongColumn(this, string);
                    break;
                }
                case 5: {
                    column = new DateColumn(this, string, "dd-mmm-yyyy");
                    break;
                }
                case 6: {
                    column = new CurrencyColumn(this, string, '$', 2);
                    break;
                }
                case 7: {
                    column = new FloatColumn(this, string);
                    break;
                }
                case 8: {
                    column = new DoubleColumn(this, string);
                    break;
                }
                case 9: {
                    column = new IndexColumn(this, string, 0);
                    break;
                }
                case 10: {
                    column = new BlobColumn(this, string, 0);
                    break;
                }
                case 1: {
                    column = new ByteColumn(this, string);
                    if (!string.equals("$$control")) break;
                    this.controlCol = (ByteColumn)column;
                    break;
                }
                default: {
                    throw new SQLException("Corrupt columns table");
                }
            }
            column.setCacheCondition(n6, n7, true);
            column.recOffset = n4;
            column.colID = new Integer(n2);
            if (string2.indexOf(".PK") >= 0) {
                column.setBooleanProperty(1, true);
            }
            if (string2.indexOf(".UNIQ") >= 0) {
                column.setBooleanProperty(2, true);
            }
            if (string2.indexOf(".~NULL") >= 0) {
                column.setBooleanProperty(3, true);
            }
            if (!StringColumn.testNull(string3)) {
                column.setProperty(4, string3);
            }
            ++n;
        }
        try {
            if (!this.open(this.tableName)) {
                throw new SQLException("Could not open table " + this.tableName + " in path " + this.path);
            }
            this.dbase.traceMemory();
        }
        catch (IOException iOException) {
            throw new SQLException("IO problem: " + iOException.toString() + iOException.getMessage());
        }
    }

    static {
        rowdel = new Integer(1);
        rowvalid = new Integer(0);
    }
}

