/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.Cache;
import db.Column;
import db.Database;
import db.Trace;
import java.sql.SQLException;

class RowRangeCache
implements Cache {
    static int cacheHits;
    Column col;
    int lowRow;
    int highRow;
    int count;
    int[] range;
    Object[] objectCache;
    int cacheCondition;
    int cacheAmount;
    boolean cacheAll;
    float avgRow;
    int altCacheHits;
    int thisCacheHits;
    int missesInCacheStats;
    float cacheReset;
    Database dbase;

    public void setRange(Column column, int n, int n2) throws SQLException {
        this.col = column;
        this.lowRow = n;
        this.dbase = this.col.dbase;
        this.missesInCacheStats = this.dbase.getIntegerProperty("missesInCacheStats", "100");
        int n3 = this.dbase.getIntegerProperty("cacheResetPercent", "10");
        this.cacheReset = (100.0f + (float)n3) / 100.0f;
        String string = this.dbase.getStringProperty("cacheCondition", "CACHE_ROWS");
        if (string.equalsIgnoreCase("CACHE_ROWS")) {
            this.cacheCondition = 1;
            this.cacheAmount = this.dbase.getIntegerProperty("cacheAmount", "256");
        } else {
            if (!string.equalsIgnoreCase("CACHE_PERCENT")) {
                throw new SQLException("Invalid cache condition: " + string, "XOPEN?");
            }
            this.cacheAmount = this.dbase.getIntegerProperty("cacheAmount", "10");
            this.cacheCondition = 2;
        }
        this.setCacheCondition(this.cacheCondition, this.cacheAmount);
    }

    public void setCacheCondition(int n, int n2) {
        this.cacheAmount = n2;
        this.cacheCondition = n;
        this.highRow = this.lowRow + this.cacheAmount - 1;
        this.range = new int[2];
        this.range[0] = this.lowRow;
        this.range[1] = this.highRow;
        this.count = this.highRow - this.lowRow + 1;
        this.objectCache = new Object[this.highRow - this.lowRow + 1];
        if (this.cacheCondition == 2 && this.cacheAmount == 100) {
            this.cacheAll = true;
        }
        if (Trace.traceIt(64)) {
            Trace.traceOut(this.col.colName + " has cache size " + (this.highRow - this.lowRow + 1));
        }
    }

    public boolean add(Object object, int n) {
        if (n < this.lowRow || n > this.highRow) {
            if (this.cacheCondition == 1) {
                return false;
            }
            int n2 = this.highRow;
            int n3 = this.lowRow;
            while (n > n2) {
                n2 *= 2;
            }
            while (n < n3) {
                n3 /= 2;
            }
            if (n2 - n3 > this.cacheAmount * this.col.cTable.rowCount / 50) {
                return false;
            }
            Object[] objectArray = new Object[n2 - n3 + 1];
            int n4 = this.lowRow;
            while (n4 <= this.highRow) {
                objectArray[n4 - n3] = this.objectCache[n4 - this.lowRow];
                ++n4;
            }
            this.objectCache = objectArray;
            this.lowRow = n3;
            this.highRow = n2;
            this.range[0] = this.lowRow;
            this.range[1] = this.highRow;
            if (Trace.traceIt(64)) {
                Trace.traceOut(this.col.colName + " has cache size " + (this.highRow - this.lowRow + 1));
            }
        }
        this.objectCache[n - this.lowRow] = object;
        return true;
    }

    public Object get(int n) {
        if (n < this.lowRow || n > this.highRow) {
            return null;
        }
        return this.objectCache[n - this.lowRow];
    }

    public int[] getRange() {
        return this.range;
    }

    RowRangeCache() {
    }
}

