/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.BlobColumn;
import db.Column;
import db.Database;
import db.Table;
import db.Trace;
import db.Transaction;
import db.idbDataOutputStream;
import db.indexTable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.sql.SQLException;
import java.util.Vector;

public class Journal {
    static Integer int0 = new Integer(0);
    static Integer int1 = new Integer(1);
    static final int TR_NONE = 0;
    static final int TR_NORMAL = 1;
    static final int TR_KEEP = 2;
    static final int TR_READ = 0;
    static final int TR_WRITE = 1;
    static final int TR_BEGIN = 1113941870;
    static final int TR_END = 1164275295;
    static final int TR_INSERT = 1231975028;
    static final int TR_DELETE = 1147497588;
    static final int TR_INS_BLOB = 1231187042;
    static final int TR_DEL_BLOB = 1147300962;
    static final int TR_CHECKPOINT = 1130915179;
    static final int TR_MARKER = 1416782190;
    static final int TR_BASE = 1000;
    static final int TR_COMMIT = 1;
    static final int TR_ROLLBACK = 2;
    File jrlFile;
    RandomAccessFile Log;
    FileDescriptor fd;
    int activeCount;
    Vector transactionList;
    long nextTransactionID;
    int transLevel;
    String systemDir;
    String filename;
    Database dbase;
    idbDataOutputStream DataOut;
    Table[] tblList;

    private void openLog() throws SQLException {
        if (this.transLevel == 0) {
            return;
        }
        try {
            this.jrlFile = new File(this.systemDir, this.filename);
            this.Log = new RandomAccessFile(this.jrlFile, "rw");
            this.fd = this.Log.getFD();
            if (this.Log.length() > 15L) {
                int n = this.Log.readInt();
                this.Log.readInt();
                if (n > 3) {
                    throw new SQLException("Journal file created with a later version.");
                }
                this.nextTransactionID = this.Log.readLong();
                if (this.nextTransactionID < 1000L) {
                    throw new SQLException("Internal error - illegal transaction ID: " + this.nextTransactionID);
                }
            } else {
                this.Log.writeInt(3);
                this.Log.writeInt(13);
                this.Log.writeLong(this.nextTransactionID);
            }
            this.Log.seek(this.Log.length());
        }
        catch (IOException iOException) {
            throw new SQLException("Problem opening/creating journal file: " + this.filename + " " + iOException.toString());
        }
    }

    synchronized void closeLog() throws SQLException {
        try {
            if (this.Log == null) {
                return;
            }
            this.Log.close();
            this.Log = null;
        }
        catch (IOException iOException) {
            throw new SQLException("Problem closing journal file: " + this.filename + " " + iOException.toString());
        }
    }

    synchronized void updateTransactionCount(int n) throws SQLException {
        this.activeCount += n;
        if (this.activeCount < 0 || this.activeCount > this.transactionList.size()) {
            throw new SQLException("Internal error - active transaction count=" + this.activeCount);
        }
        if (this.activeCount == 0) {
            if (this.transLevel < 2) {
                try {
                    this.Log.close();
                    this.jrlFile.delete();
                }
                catch (Exception exception) {
                    throw new SQLException("Problem deleting journal file " + exception.toString());
                }
                this.openLog();
            } else {
                this.writeTransactionRecord(null, 1130915179, 0, null, null, null);
            }
        }
        if (Trace.traceIt(16)) {
            Trace.traceOut("Active transactions " + this.activeCount);
        }
    }

    synchronized long getNextTransactionID() {
        long l = ++this.nextTransactionID;
        if (Trace.traceIt(16)) {
            Trace.traceOut("Allocated trans ID " + this.nextTransactionID);
        }
        return l;
    }

    synchronized void addToTransactionList(Transaction transaction) throws SQLException {
        this.transactionList.addElement(transaction);
    }

    public synchronized void removeFromTransactionList(Transaction transaction) throws SQLException {
        this.transactionList.removeElement(transaction);
    }

    synchronized void writeTransactionRecord(Transaction transaction, int n, int n2, Table table, Column column, Object object) throws SQLException {
        if (this.transLevel == 0) {
            return;
        }
        long l = 1000L;
        if (n != 1130915179) {
            l = transaction.ID;
            if (l < 1000L) {
                throw new SQLException("Internal error - illegal transaction ID: " + transaction.ID);
            }
            if (!transaction.used) {
                transaction.used = true;
                this.updateTransactionCount(1);
                this.writeTransactionRecord(transaction, 1113941870, 0, null, null, null);
            }
        }
        try {
            this.DataOut.reset();
            this.DataOut.writeInt(1416782190);
            this.DataOut.writeLong(l);
            this.DataOut.writeInt(n);
            long l2 = 0L;
            switch (n) {
                case 1164275295: {
                    this.DataOut.writeVarInt(n2);
                    if (!Trace.traceIt(16)) break;
                    Trace.traceOut("Trans " + l + " End status=" + n2);
                    break;
                }
                case 1231975028: {
                    Object object2;
                    this.DataOut.writeVarInt(table.getTableID());
                    this.DataOut.writeVarInt(n2);
                    if (table instanceof indexTable) {
                        object2 = (indexTable)table;
                        this.DataOut.writeVarInt(((indexTable)object2).getKeyByRow(n2));
                        this.DataOut.writeVarInt(((indexTable)object2).getRowByRow(n2));
                    } else {
                        object2 = (byte[])object;
                        this.DataOut.writeVarBytes((byte[])object2);
                    }
                    if (!Trace.traceIt(16)) break;
                    Trace.traceOut("Trans " + l + " Insert row=" + n2 + " Table = " + table.getTableName());
                    break;
                }
                case 1147497588: {
                    this.DataOut.writeVarInt(table.getTableID());
                    this.DataOut.writeVarInt(n2);
                    byte by = (byte)(table.noAutoInc ? 1 : 0);
                    this.DataOut.writeByte(by);
                    if (!Trace.traceIt(16)) break;
                    Trace.traceOut("Trans " + l + " Delete row=" + n2 + " Table = " + table.getTableName() + " noAutoInc = " + by);
                    break;
                }
                case 1231187042: {
                    l2 = (Long)object;
                    this.DataOut.writeVarInt(table.getTableID());
                    this.DataOut.writeVarInt(column.getColID());
                    this.DataOut.writeLong(l2);
                    if (!Trace.traceIt(16)) break;
                    Trace.traceOut("Trans " + l + " Insert Blob offset=" + l2);
                    break;
                }
                case 1147300962: {
                    l2 = (Long)object;
                    this.DataOut.writeVarInt(table.getTableID());
                    this.DataOut.writeVarInt(column.getColID());
                    this.DataOut.writeLong(l2);
                    transaction.blobCols.addElement(column);
                    transaction.blobOffsets.addElement(object);
                    if (!Trace.traceIt(16)) break;
                    Trace.traceOut("Trans " + l + " Delete Blob offset=" + l2);
                    break;
                }
            }
            this.DataOut.writeVarInt(this.DataOut.count);
            RandomAccessFile randomAccessFile = this.Log;
            synchronized (randomAccessFile) {
                this.Log.write(this.DataOut.buff, 0, this.DataOut.count);
                if (!this.dbase.fastUpdate && n == 1) {
                    this.fd.sync();
                }
            }
        }
        catch (IOException iOException) {
            throw new SQLException("Error writing transaction record: " + iOException.toString());
        }
    }

    private long getRecordID() throws IOException, SQLException {
        long l = this.Log.getFilePointer();
        this.Log.seek(l - 4L);
        int n = this.Log.readInt();
        l = l - (long)n - 4L;
        this.Log.seek(l);
        int n2 = this.Log.readInt();
        if (n2 != 1416782190) {
            throw new SQLException("Internal error - could not read transaction marker");
        }
        long l2 = this.Log.readLong();
        if (l2 < 1000L) {
            throw new SQLException("Internal error - illegal transaction ID: " + l2);
        }
        return l2;
    }

    public synchronized void doRecovery(boolean bl) throws IOException, SQLException {
        if (this.Log == null) {
            return;
        }
        if (this.Log.length() < 9L) {
            return;
        }
        if (Trace.traceIt(16)) {
            Trace.traceOut("Recoverying incomplete transactions, systemOnly=" + bl);
        }
        int n = 0;
        Vector<Long> vector = new Vector<Long>(10, 10);
        long l = this.Log.getFilePointer();
        int n2 = this.activeCount;
        Transaction transaction = new Transaction(this.dbase);
        while (l > 16L) {
            long l2;
            this.Log.seek(l);
            transaction.ID = l2 = this.getRecordID();
            if (l2 >= this.nextTransactionID) {
                this.nextTransactionID = l2 + 1L;
            }
            l = this.Log.getFilePointer() - 12L;
            int n3 = this.Log.readInt();
            if (n3 == 1130915179) break;
            boolean bl2 = false;
            int n4 = 0;
            while (n4 < vector.size()) {
                Long l3 = (Long)vector.elementAt(n4);
                if (l2 == l3) {
                    bl2 = true;
                    break;
                }
                ++n4;
            }
            if (bl2) continue;
            vector.addElement(new Long(l2));
            if (n3 == 1164275295 || n3 == 1113941870 || ((n4 = this.Log.readInt()) > 1004 || !bl) && (n4 <= 1004 || bl)) continue;
            this.Log.seek(this.Log.length());
            this.activeCount = 2;
            transaction.used = true;
            this.rollback(transaction);
            ++n;
        }
        this.activeCount = n2;
        this.removeFromTransactionList(transaction);
        this.Log.seek(this.Log.length());
        if (!bl) {
            this.writeTransactionRecord(null, 1130915179, 0, null, null, null);
        }
        if (Trace.traceIt(16)) {
            Trace.traceOut("Recovery complete. " + vector.size() + " found, " + n + " rolled back");
        }
    }

    private Table getTableByID(int n) {
        int n2 = 0;
        while (n2 < this.tblList.length) {
            if (this.tblList[n2].getTableID() == n) {
                return this.tblList[n2];
            }
            ++n2;
        }
        return null;
    }

    public synchronized void rollback(Transaction transaction) throws SQLException {
        if (!transaction.used) {
            transaction.freeAllLocks(true);
            return;
        }
        transaction.deleteBlobs(false);
        this.tblList = this.dbase.getTableArray();
        if (Trace.traceIt(16)) {
            Trace.traceOut("Rolling back transaction " + transaction.ID);
        }
        long l = 0L;
        try {
            l = this.Log.getFilePointer();
            if (l != this.Log.length()) {
                throw new SQLException("Internal error - journal pointer not at end\n" + "fp=" + l + " Journal length=" + this.Log.length());
            }
        }
        catch (Exception exception) {
            throw new SQLException(exception.toString());
        }
        long l2 = l;
        block16: while (true) {
            try {
                this.Log.seek(l2);
                long l3 = this.getRecordID();
                l2 = this.Log.getFilePointer() - 12L;
                if (l3 != transaction.ID) continue;
                int n = this.Log.readInt();
                switch (n) {
                    case 1113941870: {
                        this.Log.seek(l);
                        this.writeTransactionRecord(transaction, 1164275295, 2, null, null, null);
                        transaction.freeAllLocks(true);
                        this.getNextTransactionID();
                        transaction.used = false;
                        this.updateTransactionCount(-1);
                        if (Trace.traceIt(16)) {
                            Trace.traceOut("Rollback complete");
                        }
                        this.tblList = null;
                        return;
                    }
                    case 1164275295: {
                        int n2 = this.Log.readInt();
                        if (!Trace.traceIt(16)) continue block16;
                        Trace.traceOut("End status=" + n2);
                        break;
                    }
                    case 1231975028: {
                        int n3 = this.Log.readInt();
                        int n4 = this.Log.readInt();
                        Table table = this.getTableByID(n3);
                        if (Trace.traceIt(16)) {
                            Trace.traceOut(" Un-Insert row=" + n4 + " Table " + table.getTableName());
                        }
                        table.deleteRow(n4, null);
                        break;
                    }
                    case 1147497588: {
                        Object var21_18;
                        int n3 = this.Log.readInt();
                        int n4 = this.Log.readInt();
                        byte by = this.Log.readByte();
                        Table table = this.getTableByID(n3);
                        table.doingRollback = true;
                        if (Trace.traceIt(16)) {
                            Trace.traceOut(" Un-Delete row=" + n4 + " Table " + table.getTableName() + " noAutoInc=" + by);
                        }
                        Vector<Integer> vector = new Vector<Integer>(table.getColCount());
                        table.getRow(n4, vector);
                        vector.setElementAt(int0, 0);
                        boolean bl = table.noAutoInc;
                        try {
                            try {
                                table.noAutoInc = by == 1;
                                table.addRowAtRow(vector, n4, null);
                            }
                            catch (Exception exception) {
                                System.out.println("Error un-deleting row: " + exception.toString());
                                var21_18 = null;
                                table.noAutoInc = bl;
                                table.doingRollback = false;
                                break;
                            }
                            var21_18 = null;
                            table.noAutoInc = bl;
                            table.doingRollback = false;
                            break;
                        }
                        catch (Throwable throwable) {
                            var21_18 = null;
                            table.noAutoInc = bl;
                            table.doingRollback = false;
                            throw throwable;
                        }
                    }
                    case 1231187042: {
                        int n3 = this.Log.readInt();
                        Integer n5 = new Integer(this.Log.readInt());
                        long l4 = this.Log.readLong();
                        Table table = this.getTableByID(n3);
                        BlobColumn blobColumn = (BlobColumn)table.getColByID(n5);
                        blobColumn.deleteBlob(l4);
                        if (!Trace.traceIt(16)) continue block16;
                        Trace.traceOut(" Un-Insert Blob offset=" + l4 + " Column " + n5);
                        break;
                    }
                    case 1147300962: {
                        int n3 = this.Log.readInt();
                        Integer n5 = new Integer(this.Log.readInt());
                        long l4 = this.Log.readLong();
                        Table table = this.getTableByID(n3);
                        BlobColumn blobColumn = (BlobColumn)table.getColByID(n5);
                        if (!Trace.traceIt(16)) continue block16;
                        Trace.traceOut(" Un-Delete Blob offset=" + l4 + " Column " + n5);
                        break;
                    }
                }
                continue;
            }
            catch (Exception exception) {
                System.out.println(Thread.currentThread().getName() + " Exception during rollback " + exception.toString());
                continue;
            }
            break;
        }
    }

    void commitAll() throws SQLException {
        Vector vector = this.transactionList;
        synchronized (vector) {
            int n = 0;
            while (n < this.transactionList.size()) {
                Transaction transaction = (Transaction)this.transactionList.elementAt(n);
                transaction.commit(transaction.getSqlID());
                ++n;
            }
        }
    }

    public Journal(Database database) throws SQLException {
        this.dbase = database;
        this.DataOut = new idbDataOutputStream(2048, 16);
        if (this.Log == null) {
            this.transLevel = 1;
            this.filename = this.dbase.filename + ".jrl";
            this.systemDir = this.dbase.systemPath;
            this.transLevel = this.dbase.transLevel;
            this.transactionList = new Vector(10, 10);
            this.nextTransactionID = 1000L;
            this.openLog();
        }
    }
}

