/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.Column;
import db.Table;
import db.Transaction;
import db.idbDataOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.sql.SQLException;

class FloatColumn
extends Column {
    static final float NULL_VALUE = Float.NaN;
    static int time;

    public boolean isAutoIncrement() {
        return false;
    }

    public boolean isNull(Object object) {
        Float f = (Float)object;
        return f.equals(this.nullObj);
    }

    void setBooleanProperty(int n, boolean bl) {
        super.setBooleanProperty(n, bl);
    }

    void setProperty(int n, Object object) {
        switch (n) {
            case 4: {
                if (object == null) {
                    super.setProperty(n, null);
                    return;
                }
                Float f = new Float((String)object);
                if (f.floatValue() == Float.NaN && !this.dbase.microsoftVM) {
                    throw new NumberFormatException(object.toString());
                }
                super.setProperty(n, f);
                break;
            }
            default: {
                super.setProperty(n, object);
            }
        }
    }

    void write(RandomAccessFile randomAccessFile) throws IOException {
    }

    void close(RandomAccessFile randomAccessFile) throws IOException {
    }

    void read(RandomAccessFile randomAccessFile) throws IOException {
    }

    Object toObject(Object object) {
        Float f;
        if (object == null) {
            return this.nullObj;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() == 0) {
                return this.nullObj;
            }
            try {
                f = new Float(string);
            }
            catch (Exception exception) {
                return null;
            }
        } else {
            if (object instanceof Float) {
                return (Float)object;
            }
            if (object instanceof Number) {
                float f2 = ((Number)object).floatValue();
                f = new Float(f2);
            } else {
                return null;
            }
        }
        if (Float.NaN == f.floatValue() && !this.allowAccidentalNulls) {
            if (f.floatValue() == 0.0f) {
                return f;
            }
            return null;
        }
        return f;
    }

    void writeObject(idbDataOutputStream idbDataOutputStream2, Object object, Transaction transaction, int n) throws IOException {
        float f = ((Float)object).floatValue();
        idbDataOutputStream2.writeFloat(f);
    }

    public String toString(Object object) {
        String string = ((Float)object).isNaN() ? "NULL" : object.toString();
        return string;
    }

    Object getByRow(int n) throws SQLException {
        Object object = super.getByRow(n);
        if (object == null) {
            try {
                float f = this.cTable.dataIn.readFloat();
                this.cTable.freeReadAhead();
                object = new Float(f);
            }
            catch (Exception exception) {
                throw new SQLException("IO problem: " + exception.toString() + exception.getMessage());
            }
            this.rowCache.add(object, n);
        }
        return object;
    }

    boolean numeric() {
        return true;
    }

    boolean hashPreservesOrder() {
        return false;
    }

    int getHash(Object object) {
        return Float.floatToIntBits(((Number)object).floatValue());
    }

    static boolean compareVals(Object object, Object object2, int n, boolean bl) throws SQLException {
        float f = ((Number)object).floatValue();
        float f2 = ((Number)object2).floatValue();
        if (object instanceof Float && object2 instanceof Float) {
            if (bl) {
                if (n == 1) {
                    if (((Float)object).isNaN() && ((Float)object2).isNaN()) {
                        return true;
                    }
                } else if (n == 4 && ((Float)object).isNaN() && ((Float)object2).isNaN()) {
                    return false;
                }
            } else {
                if (((Float)object).isNaN()) {
                    return false;
                }
                if (((Float)object2).isNaN()) {
                    return false;
                }
            }
        }
        switch (n) {
            case 1: {
                return f == f2;
            }
            case 4: {
                return f != f2;
            }
            case 7: {
                return f < f2;
            }
            case 8: {
                return f <= f2;
            }
            case 5: {
                return f > f2;
            }
            case 6: {
                return f >= f2;
            }
        }
        throw new SQLException("Internal error: undefined operation: " + n, "XOPEN?");
    }

    boolean compare(int n, Object object, int n2, boolean bl) throws SQLException {
        return FloatColumn.compareVals(this.getByRow(n), object, n2, bl);
    }

    FloatColumn(Table table, String string) throws SQLException, NumberFormatException {
        super(table, string, 4);
        this.nullObj = new Float(Float.NaN);
        this.type = 7;
    }
}

