/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.BTreeObject;

class BTree {
    BTree ge;
    BTree lt;
    int geLength;
    int ltLength;
    BTreeObject value;
    int index;

    void reBalance(BTree bTree) {
        if (Math.abs(this.geLength - this.ltLength) < 2) {
            return;
        }
        BTree bTree2 = null;
        BTree bTree3 = null;
        if (this.geLength > this.ltLength) {
            bTree3 = this.ge;
            bTree2 = bTree3.lt;
            bTree3.lt = this;
            this.ge = bTree2;
            this.geLength = this.ge == null ? 0 : this.ge.getLength();
            bTree3.ltLength = this.getLength() + 1;
        } else {
            bTree3 = this.lt;
            bTree2 = bTree3.ge;
            bTree3.ge = this;
            this.lt = bTree2;
            this.ltLength = this.lt == null ? 0 : this.lt.getLength();
            bTree3.geLength = this.getLength() + 1;
        }
        if (bTree.ge == this) {
            bTree.ge = bTree3;
            bTree.geLength = bTree3.getLength() + 1;
        } else {
            bTree.lt = bTree3;
            bTree.ltLength = bTree3.getLength() + 1;
        }
    }

    int getLength() {
        if (this.geLength > this.ltLength) {
            return this.geLength;
        }
        return this.ltLength;
    }

    void add(int n) {
        if (this.value.lt(n, this.index)) {
            if (this.lt == null) {
                this.lt = new BTree(this.value, n);
            } else {
                this.lt.add(n);
            }
            this.ltLength = this.lt.getLength() + 1;
            this.lt.reBalance(this);
        } else {
            if (this.ge == null) {
                this.ge = new BTree(this.value, n);
            } else {
                this.ge.add(n);
            }
            this.geLength = this.ge.getLength() + 1;
            this.ge.reBalance(this);
        }
    }

    int getMax() {
        if (this.ge != null) {
            return this.ge.getMax();
        }
        return this.index;
    }

    BTree deleteMax() {
        BTree bTree;
        if (this.ge == null) {
            return this.lt;
        }
        this.ge = bTree = this.ge.deleteMax();
        return this;
    }

    void dump(int n) {
        if (this.ge != null) {
            this.ge.dump(n + 1);
        }
        int n2 = 0;
        while (n2 < n) {
            System.out.print("-");
            ++n2;
        }
        System.out.println(this.index);
        if (this.lt != null) {
            this.lt.dump(n + 1);
        }
    }

    int setSortPosn(int[] nArray, int n) {
        int n2 = n;
        if (this.lt != null) {
            n2 = this.lt.setSortPosn(nArray, n);
        }
        nArray[n2++] = this.index;
        if (this.ge == null) {
            return n2;
        }
        return this.ge.setSortPosn(nArray, n2);
    }

    void sort() {
        int n = this.value.getCount();
        int[] nArray = new int[n];
        this.setSortPosn(nArray, 0);
        int n2 = 0;
        while (n2 < n - 1) {
            int n3 = nArray[n2];
            while (n3 < n2) {
                n3 = nArray[n3];
            }
            if (n3 != n2) {
                this.value.swap(n2, n3);
            }
            ++n2;
        }
    }

    void sortNoSwap() {
        int n = this.value.getCount();
        int[] nArray = new int[n];
        this.setSortPosn(nArray, 0);
        this.value.setOrder(nArray);
    }

    BTree(BTreeObject bTreeObject, int n) {
        this.value = bTreeObject;
        this.index = n;
    }
}

