/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import jdbc.idbResultsSet;

class QueryPanel
extends JPanel {
    JComboBox tables;
    JComboBox columns;
    JComboBox sqlCommands;
    JTextField sqlText;
    JTextField rowCount;
    JButton submitButton;
    ActionListener theHandler;
    JFrame applicationFrame;
    JLabel statusBar;
    Connection con;
    SQLBuilder parent;
    JTable outputTable;
    JScrollPane scrollpane;
    Statement stmt;
    ResultSet rs;
    String[] selectedCols;
    StringBuffer selectBuf;
    int selectCount;
    boolean firstTime;

    void addResultsToList(ResultSet resultSet, JComboBox jComboBox, String string) throws SQLException {
        if (jComboBox.getItemCount() > 0) {
            jComboBox.removeAllItems();
        }
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        int n2 = resultSet.findColumn(string);
        while (resultSet.next()) {
            this.firstTime = true;
            jComboBox.addItem(resultSet.getString(n2));
        }
    }

    void getColumns() {
        try {
            String string = (String)this.tables.getSelectedItem();
            DatabaseMetaData databaseMetaData = this.con.getMetaData();
            ResultSet resultSet = databaseMetaData.getColumns(null, null, string, "%");
            this.addResultsToList(resultSet, this.columns, "COLUMN_NAME");
            this.selectedCols = new String[this.columns.getItemCount()];
            resultSet.close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, exception.toString(), "Error getting columns", -1);
        }
    }

    void getTables() {
        try {
            DatabaseMetaData databaseMetaData = this.con.getMetaData();
            ResultSet resultSet = databaseMetaData.getTables(null, null, "%", null);
            this.addResultsToList(resultSet, this.tables, "TABLE_NAME");
            resultSet.close();
            this.getColumns();
            this.firstTime = false;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, exception.toString(), "Error getting tables", -1);
        }
    }

    void onConnect(Connection connection) {
        this.con = connection;
        this.getTables();
        try {
            this.stmt = this.con.createStatement();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    QueryPanel(SQLBuilder sQLBuilder) {
        super(new GridBagLayout());
        this.parent = sQLBuilder;
        this.applicationFrame = this.parent.getFrame();
        this.statusBar = this.parent.getStatusBar();
        QueryPanel queryPanel = this;
        if (queryPanel == null) {
            throw null;
        }
        this.theHandler = queryPanel.new theListener();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        JLabel jLabel = new JLabel("Tables");
        this.add((Component)jLabel, gridBagConstraints);
        jLabel = new JLabel("Columns");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridx = 1;
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jLabel = new JLabel("Enter row limit:");
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        this.tables = new JComboBox();
        this.add((Component)this.tables, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.columns = new JComboBox();
        this.add((Component)this.columns, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        this.rowCount = new JTextField(20);
        this.add((Component)this.rowCount, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        this.submitButton = new JButton("Submit");
        this.add((Component)this.submitButton, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jLabel = new JLabel("Query:");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        this.add((Component)jLabel, gridBagConstraints);
        this.sqlText = new JTextField(50);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.sqlText, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weighty = 1.0;
        this.outputTable = new JTable();
        JScrollPane jScrollPane = new JScrollPane(this.outputTable);
        this.add((Component)jScrollPane, gridBagConstraints);
        this.tables.addActionListener(this.theHandler);
        this.columns.addActionListener(this.theHandler);
        this.submitButton.addActionListener(this.theHandler);
        this.sqlText.addActionListener(this.theHandler);
        this.selectBuf = new StringBuffer("SELECT ");
    }

    class theListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (actionEvent.getSource() == QueryPanel.this.tables) {
                    QueryPanel.this.getColumns();
                    String string = (String)QueryPanel.this.tables.getSelectedItem();
                    String string2 = "SELECT * FROM " + string;
                    QueryPanel.this.sqlText.setText(string2);
                    QueryPanel.this.selectCount = 0;
                    QueryPanel.this.firstTime = false;
                } else if (actionEvent.getSource() == QueryPanel.this.columns) {
                    if (QueryPanel.this.firstTime) {
                        QueryPanel.this.firstTime = false;
                        return;
                    }
                    String string = (String)QueryPanel.this.columns.getSelectedItem();
                    QueryPanel.this.selectBuf.setLength(7);
                    QueryPanel.this.selectedCols[QueryPanel.this.selectCount++] = string;
                    int n = 0;
                    while (n < QueryPanel.this.selectCount) {
                        if (n != 0) {
                            QueryPanel.this.selectBuf.append(',');
                        }
                        QueryPanel.this.selectBuf.append(QueryPanel.this.selectedCols[n]);
                        ++n;
                    }
                    String string3 = (String)QueryPanel.this.tables.getSelectedItem();
                    QueryPanel.this.selectBuf.append(" FROM " + string3);
                    QueryPanel.this.sqlText.setText(QueryPanel.this.selectBuf.toString());
                } else if (actionEvent.getSource() == QueryPanel.this.submitButton) {
                    String string = QueryPanel.this.rowCount.getText();
                    if (!string.equals("")) {
                        QueryPanel.this.stmt.setMaxRows(Integer.parseInt(string));
                    } else {
                        QueryPanel.this.stmt.setMaxRows(0);
                    }
                    if (QueryPanel.this.stmt.execute(QueryPanel.this.sqlText.getText())) {
                        QueryPanel.this.rs = QueryPanel.this.stmt.getResultSet();
                        QueryPanel queryPanel = QueryPanel.this;
                        if (queryPanel == null) {
                            throw null;
                        }
                        QueryPanel.this.outputTable.setModel(queryPanel.new ResultModel());
                        QueryPanel.this.parent.onQuery(QueryPanel.this.rs);
                    }
                }
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
            }
        }

        theListener() {
        }
    }

    class ResultModel
    extends AbstractTableModel {
        String blank = " ";

        boolean resultsOK() throws SQLException {
            if (QueryPanel.this.rs == null) {
                return false;
            }
            QueryPanel.this.rs.getMetaData();
            return true;
        }

        public int getColumnCount() {
            try {
                if (!this.resultsOK()) {
                    return 10;
                }
                return QueryPanel.this.rs.getMetaData().getColumnCount();
            }
            catch (Exception exception) {
                return 10;
            }
        }

        public int getRowCount() {
            try {
                if (!this.resultsOK()) {
                    return 100;
                }
                if (!(QueryPanel.this.rs instanceof idbResultsSet)) {
                    return 1000;
                }
                return ((idbResultsSet)QueryPanel.this.rs).getRowCount();
            }
            catch (Exception exception) {
                return 100;
            }
        }

        public Object getValueAt(int n, int n2) {
            try {
                if (!this.resultsOK()) {
                    return this.blank;
                }
                if (!(QueryPanel.this.rs instanceof idbResultsSet)) {
                    if (!QueryPanel.this.rs.next()) {
                        return this.blank;
                    }
                    return QueryPanel.this.rs.getString(n2 + 1);
                }
                ((idbResultsSet)QueryPanel.this.rs).setCurRow(n + 1);
                QueryPanel.this.rs.next();
                return QueryPanel.this.rs.getString(n2 + 1);
            }
            catch (Exception exception) {
                return this.blank;
            }
        }

        public String getColumnName(int n) {
            try {
                if (!this.resultsOK()) {
                    return new Integer(n).toString();
                }
                return QueryPanel.this.rs.getMetaData().getColumnName(n + 1);
            }
            catch (Exception exception) {
                return new Integer(n).toString();
            }
        }

        ResultModel() {
        }
    }
}

