/**
 * Copyright @ 2000 Peter Robach (pr@webapp.de) and Lars Rwekamp (Lars@openKnowlege.de)
 *r
 * Source is only for non commercialand coaching usage.
 *
 * Not Warranty to use it.
 */

package de.ix.jspTutorial.model;
import java.util.*;
import java.net.URL;
import java.io.*;
import javax.servlet.ServletContext;
import de.ix.jspTutorial.constants.SessionConstants ;

/**
 * This class represents the list of pizza ingredients.
 *
 *
 * @author Peter Rossbach (<a href="mailto://pr@webapp.de">pr@webapp.de</a>), Lars Rwekamp ( <a href="mailto://lars.roewekamp@openKnowledge.de">lars.roewekamp@openKnowledge.de</a>)
 * @version $Id:$
 */
public class IngredientList {

  /**
    * version of the source
    */
  public static String vcid = "$Id:$";

  /**
   * List of ingredients
   */
   private TreeMap ingredients;

   /**
    * Constructor for an empty list of ingredients
    *
    * @see IngredientList#readList(ServletContext)
    */
   public IngredientList() {
      this.ingredients = new TreeMap();
   }

   /**
    * Constructor for a list of ingredients.
    *
    * @param ingredients list of initial ingredients
    *
    * @see IngredientList#readList(ServletContext)
    */
   public IngredientList(TreeMap ingredients) {
      this.ingredients = ingredients;
   }

   /**
    * Getter method for one ingredient
    *
    * @param  key unique identifier of the requested ingredient
    *
    * @return requested ingredient
    */
   public Ingredient getIngredient(Long key) {
      return (Ingredient) ingredients.get(key);
   }

   /**
    * Getter method for the attribute <code>ingredients</code>
    *
    * @return TreeMap representing the ingredient list
    */
   public TreeMap getIngredients() {
      return ingredients;
   }

   /**
    * Read all posible ingredients out of the session or db with the
    * help of the <code>PizzaAccessor</code> object.
    *
    * @param aApplication the application
    */
   public void readList(ServletContext aApplication) {
      PizzaAccessor theAccessor = (PizzaAccessor) aApplication.getAttribute(SessionConstants.PIZZA_ACCESSOR) ;
      if(theAccessor != null) {
   	   theAccessor.log("Read ingredients") ;
   	   ingredients = theAccessor.readIngredientList(aApplication) ;
      } else
	 new RuntimeException ("Can't Access Database for ingredients") ;
   }

  /**
    * Build a string out of the ingredient list.
    *
    * @return String representation of the ingredient list
    *
    */
   public String toString() {
      StringBuffer outStr = new StringBuffer();
      Set    entrySet = ingredients.entrySet();

      outStr.append("[") ;
      for (Iterator iter = entrySet.iterator(); iter.hasNext(); ) {
         Map.Entry entry = (Map.Entry) iter.next();

         outStr.append(((Ingredient) entry.getValue()).toString()) ;
         if(iter.hasNext())
         		outStr.append(",");
      }
      outStr.append("]") ;
      return outStr.toString();
   }
}


//
// History
//
// $Log:$
//
//