/**
 * Copyright @ 2000 Peter Robach (pr@webapp.de) and Lars Rwekamp (Lars@openKnowlege.de)
 *
 * Source is only for non commercial and coaching usage.
 *
 * Not Warranty to use it.
 */
package de.ix.jspTutorial.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpSession;

import de.ix.jspTutorial.constants.*;

/**
  * The <code>BBG_ScreenFlowManager</class> class maps the requested URL to
  * the coresponding java server pages
  *
  * @author Peter Rossbach (<a href="mailto://pr@webapp.de">pr@webapp.de</a>), Lars Rwekamp ( <a href="mailto://lars.roewekamp@openKnowledge.de">lars.roewekamp@openKnowledge.de</a>)
  * @version $Id:$
  */
public class ScreenFlowManager {

   /**
     * version of the source
     */
    public static String vcid = "$Id:$";


    /**
      *  default constructor
      */
    public ScreenFlowManager(){}



    /**
      * Calculate the next page to display depending on the current request type and
      * additional enviroment conditions.
      *
      * @param request HttpServletRequest
      * @return Name of the next page to display
      */
    public String getNextPageName(HttpServletRequest request)  {

        String doAction                = null;
        String error                   = null;
        ModelManager pizzaModelManager = null;

        pizzaModelManager = (ModelManager)request.getSession(true).getValue(SessionConstants.MODEL_MANAGER);

        // extract do-request parameter from HttpServletRequest
        try {
          doAction = (String)request.getParameter(RequestParameterConstants.DO_ACTION);
          if (doAction==null) doAction = "";
        } catch(Exception ex) {
          doAction = "";
        }

        // extract error-attribut parameter from HttpServletRequest
        try {
          error = (String)request.getAttribute(RequestParameterConstants.ERROR);
          if (error==null) error = "";
        } catch(Exception ex) {
          error = "";
        }

        // extract requestedUrl-attribut parameter from HttpServletRequest
        String requestedUrl  = (String)request.getAttribute(RequestParameterConstants.REQUESTED_URL);

        // initial stting for next page
        String forwardPageName = PageConstants.DEF_PAGE;


        // test for expected error handling
        if (error != null && !error.equals("")) {
          // error handling ...
          if (error.equals(RequestParameterConstants.MIP_ERROR)) {
            forwardPageName = PageConstants.MIP_ERROR_PAGE;
          } else {
            forwardPageName = PageConstants.UNKNOWN_ERROR_PAGE;
          }
          return forwardPageName;
        }


        // do actions for the main user view system
        if ("".equals(doAction)) {
           // do nothing, means show the default screen.
           forwardPageName = PageConstants.DEF_PAGE;
        } else if (RequestParameterConstants.DO_LOGIN.equals(doAction) ) {
           if (pizzaModelManager.isCustomerLoggedIn()) {
              // show coice page
              forwardPageName = PageConstants.CHOICE_PAGE;
           } else {
              // show customer page
              forwardPageName = PageConstants.CUSTOMER_PAGE;
           }
        } else if (RequestParameterConstants.DO_LOGOUT.equals(doAction)) {
           // show logout page
           forwardPageName = PageConstants.LOGOUT_PAGE;
        } else if (RequestParameterConstants.SHOW_LOGIN.equals(doAction)) {
           // show customer page
           forwardPageName = PageConstants.CUSTOMER_PAGE;
        } else if (RequestParameterConstants.DO_CHOICE.equals(doAction)) {
           // show order data page
           forwardPageName = PageConstants.ORDER_PAGE;
        } else if (RequestParameterConstants.SHOW_CHOICE.equals(doAction)) {
           // show choice page
           forwardPageName = PageConstants.CHOICE_PAGE;
        } else  if (RequestParameterConstants.DO_ORDER.equals(doAction)) {
           // show confirmation page
           forwardPageName = PageConstants.CONFIRM_PAGE;
        }

        System.out.println("action '" + doAction + "' forward page '" + forwardPageName + "'") ;
        return forwardPageName;
    }


}

//
// History:
//
// $Log:$
//
//
