/**
 * Copyright @ 2000 Peter Robach (pr@webapp.de) and Lars Rwekamp (Lars@openKnowlege.de)
 *
 * Source is only for non commercialand coaching usage.
 *
 * Not Warranty to use it.
 */
package de.ix.jspTutorial.constants;

import java.util.Vector;

/**
  * Interface with all possible and allowed request parameters
  */

public interface RequestParameterConstants {



    // parameter name for the requested action command
    public static final String DO_ACTION              = "doAction";
    public static final String ERROR                  = "error";
    public static final String REQUESTED_URL          = "requestedUrl";


    //------------------------------------------------------------
    //                  ERROR  REQUEST PARAMETERS
    //------------------------------------------------------------
    public static final String MIP_ERROR              = "mipError";


    //------------------------------------------------------------
    //                  DO_ACTION REQUEST PARAMETERS
    //------------------------------------------------------------


    // real do-request parameters to identify the next function
    public static final String DO_LOGIN                = "login";
    public static final String SHOW_LOGIN              = "showlogin";
    public static final String DO_LOGOUT               = "logout";
    public static final String DO_CHOICE               = "choice";
    public static final String SHOW_CHOICE             = "showChoice";
    public static final String DO_ORDER                = "order";



    //------------------------------------------------------------
    //         ADDIIONAL REQUEST PARAMETERS FOR THE DIFFERENT
    //         APPLICATION FUNCTION CALLS
    //------------------------------------------------------------

    // LOGIN request
    public static final String CUS_ID             = "id";
    public static final String CUS_FIRSTNAME      = "firstname";
    public static final String CUS_LASTNAME       = "lastname";
    public static final String CUS_EMAIL          = "eMail";
    public static final String CUS_ADDRESS1       = "address1";
    public static final String CUS_ADDRESS2       = "address2";
    public static final String CUS_ZIP            = "zip";
    public static final String CUS_TOWN           = "town";

    public static final String[] DO_LOGIN_PARAMS  = { CUS_ID,
                                                      CUS_FIRSTNAME,
                                                      CUS_LASTNAME,
                                                      CUS_EMAIL,
                                                      CUS_ADDRESS1,
                                                      CUS_ADDRESS2,
                                                      CUS_ZIP,
                                                      CUS_TOWN};

    // CHOICE request
    public static final String INGREDIENT_IDS       = "ID_INGREDIENTS";
    public static final String PIZZA_ID             = "ID_PIZZA";


    public static final String[] DO_CHOICE_PARAMS    = {PIZZA_ID,
                                                        INGREDIENT_IDS};

    // ORDER request ( = LOGIN request )
    public static final String[] DO_ORDER_PARAMS  = { CUS_ID,
                                                      CUS_FIRSTNAME,
                                                      CUS_LASTNAME,
                                                      CUS_EMAIL,
                                                      CUS_ADDRESS1,
                                                      CUS_ADDRESS2,
                                                      CUS_ZIP,
                                                      CUS_TOWN};



}
