/*
 * Decompiled with CFR 0.152.
 */
package jdbc;

import db.Column;
import db.Database;
import db.Table;
import db.TableEncrypt;
import db.Trace;
import db.Transaction;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import jdbc.idbDatabaseMetaData;
import jdbc.idbDriver;
import jdbc.idbPreparedStatement;
import jdbc.idbStatement;

public class idbConnection
implements Connection {
    static int counter;
    static idbDriver parentDriver;
    Database db;
    String conUrl;
    String propertiesFile;
    String userID;
    Properties props;
    idbDatabaseMetaData meta;
    boolean open;
    boolean readOnlyMode;
    int id;
    boolean autoCommitSetting;
    String catalogValue;
    Transaction trans;
    boolean emulateCrash;

    public Properties getProperties() {
        return this.props;
    }

    void checkCommit(int n) throws SQLException {
        if (Trace.traceIt(16)) {
            Trace.traceOut("Checking transaction autoCommit: callersID=" + n + ", cur ID=" + this.trans.getSqlID());
        }
        if (n != this.trans.getSqlID()) {
            return;
        }
        Transaction transaction = this.trans;
        synchronized (transaction) {
            if (this.autoCommitSetting) {
                this.trans.commit(n);
            }
        }
    }

    private synchronized void trace(String string) {
        if (Trace.traceIt(1024)) {
            Trace.traceOut("Con " + this.id + " " + string);
        }
    }

    private synchronized void checkOpen() throws SQLException {
        if (!this.open) {
            this.trace("Generating SQLException: The connection is closed");
            throw new SQLException("The connection is closed", "8002");
        }
    }

    public synchronized Statement createStatement() throws SQLException {
        this.trace("Creating statement");
        this.checkOpen();
        return new idbStatement(this, 1007);
    }

    public synchronized Statement createStatement(int n, int n2) throws SQLException {
        this.trace("Creating statement");
        this.checkOpen();
        return new idbStatement(this, n2);
    }

    public synchronized PreparedStatement prepareStatement(String string) throws SQLException {
        this.trace("Creating prepared statement");
        this.checkOpen();
        return new idbPreparedStatement(this, string, 1007);
    }

    public synchronized CallableStatement prepareCall(String string) throws SQLException {
        this.trace("Creating callable statement");
        this.checkOpen();
        return null;
    }

    public synchronized String nativeSQL(String string) throws SQLException {
        this.trace("Native SQL: " + string);
        this.checkOpen();
        return string;
    }

    public synchronized void setAutoCommit(boolean bl) throws SQLException {
        this.trace("setAutoCommit " + bl);
        this.checkOpen();
        this.autoCommitSetting = bl;
    }

    public synchronized boolean getAutoCommit() throws SQLException {
        this.trace("getAutoCommit: " + this.autoCommitSetting);
        this.checkOpen();
        return this.autoCommitSetting;
    }

    public synchronized void commit() throws SQLException {
        this.trace("commit");
        if (!this.open) {
            return;
        }
        Transaction transaction = this.trans;
        synchronized (transaction) {
            this.trans.commit(this.trans.getSqlID());
        }
    }

    public synchronized void rollback() throws SQLException {
        this.trace("rollback");
        this.checkOpen();
        Transaction transaction = this.trans;
        synchronized (transaction) {
            this.db.getJournal().rollback(this.trans);
        }
    }

    public synchronized void close() throws SQLException {
        this.checkOpen();
        this.open = false;
        this.trace("close Open count=" + this.db.getOpenCount());
        idbDriver idbDriver2 = parentDriver;
        synchronized (idbDriver2) {
            if (this.emulateCrash) {
                this.db.close(true);
            } else {
                this.trans.commit(this.trans.getSqlID());
                this.db.getJournal().removeFromTransactionList(this.trans);
                this.db.close();
            }
            int n = this.db.getOpenCount();
            if (n == 0) {
                Database.removeDatabase(this.db);
                this.db = null;
                this.conUrl = null;
            }
        }
    }

    public synchronized boolean isClosed() throws SQLException {
        this.trace("isClosed: open=" + this.open);
        return !this.open;
    }

    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        this.trace("getMetaData");
        this.checkOpen();
        return this.meta;
    }

    public synchronized void setReadOnly(boolean bl) throws SQLException {
        this.trace("setReadOnly " + bl);
        this.checkOpen();
        this.readOnlyMode = bl;
    }

    public synchronized boolean isReadOnly() throws SQLException {
        this.trace("isReadOnly " + this.readOnlyMode);
        this.checkOpen();
        return this.readOnlyMode;
    }

    public synchronized void setCatalog(String string) throws SQLException {
        this.trace("setCatalog: " + string);
        this.checkOpen();
        this.catalogValue = string;
    }

    public synchronized String getCatalog() throws SQLException {
        this.trace("getCatalog: " + this.catalogValue);
        this.checkOpen();
        return null;
    }

    public synchronized void setTransactionIsolation(int n) throws SQLException {
        this.trace("setTransactionIsolation: " + n);
        this.checkOpen();
        this.trans.setTransactionIsolation(n);
    }

    public synchronized int getTransactionIsolation() throws SQLException {
        int n = this.trans.getTransactionIsolation();
        this.trace("getTransactionIsolation: " + n);
        this.checkOpen();
        return n;
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        this.trace("getWarnings");
        this.checkOpen();
        return null;
    }

    public synchronized void clearWarnings() throws SQLException {
        this.trace("clearWarnings");
        this.checkOpen();
    }

    protected void finalize() throws Throwable {
        if (this.open) {
            this.close();
        }
    }

    public boolean getAutoClose() {
        return false;
    }

    public void setAutoClose(boolean bl) {
        bl = false;
    }

    public void setTableEncryption(String string, TableEncrypt tableEncrypt) throws SQLException {
        this.db.setTableEncryption(string, tableEncrypt);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return new idbPreparedStatement(this, string, n2);
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public Map getTypeMap() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setTypeMap(Map map) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public Object getLastValueInserted(String string, String string2) throws SQLException {
        Table table = this.db.getTable(string);
        if (table == null) {
            throw new SQLException("Table: " + string + ", not found");
        }
        Column column = table.getColByName(string2);
        if (column == null) {
            throw new SQLException("Column: " + string2 + ", not found");
        }
        return column.getLastValueInserted();
    }

    idbConnection(idbDriver idbDriver2, String string, Properties properties) throws SQLException {
        String string2;
        this.conUrl = string2 = string.substring(0, 8) + ":" + string.substring(9);
        parentDriver = idbDriver2;
        this.props = properties;
        this.propertiesFile = string2.substring(9);
        Object object = parentDriver;
        synchronized (object) {
            this.db = Database.getDatabase(this.conUrl);
            if (this.db == null) {
                this.db = new Database(this.conUrl);
                Database.addDatabase(this.db);
            }
            this.id = ++counter;
        }
        this.trace("connecting to URL: " + string2 + " Open count=" + this.db.getOpenCount());
        this.userID = properties.getProperty("UserID", "guest");
        object = properties.getProperty("Password");
        String string3 = properties.getProperty("crashExit", "0");
        if (!string3.equals("0")) {
            this.emulateCrash = true;
        }
        try {
            this.trans = this.db.dbOpen(this.propertiesFile, this.userID, (String)object);
            this.trans.setConnection(this);
            this.meta = new idbDatabaseMetaData(this);
            this.open = true;
        }
        catch (Exception exception) {
            this.db = null;
            this.open = false;
            this.conUrl = null;
            throw new SQLException(exception.getMessage());
        }
        this.autoCommitSetting = true;
        this.catalogValue = "default";
    }
}

