/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.ByteColumn;
import db.Column;
import db.Table;
import db.Transaction;
import db.idbDataOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.sql.SQLException;

class IntegerColumn
extends Column {
    static final int NULL_VALUE = Integer.MIN_VALUE;
    static int time;
    static final char[] digits;
    static final String[] strCache;
    boolean autoIncrement;
    int nextIncrement;

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public boolean isNull(Object object) {
        Integer n = (Integer)object;
        return n.equals(this.nullObj);
    }

    void setBooleanProperty(int n, boolean bl) {
        switch (n) {
            case 5: {
                this.autoIncrement = bl;
                break;
            }
            default: {
                super.setBooleanProperty(n, bl);
            }
        }
    }

    void setProperty(int n, Object object) {
        switch (n) {
            case 4: {
                if (object == null) {
                    super.setProperty(n, null);
                    return;
                }
                int n2 = Integer.parseInt((String)object);
                if (n2 == Integer.MIN_VALUE) {
                    throw new NumberFormatException(object.toString());
                }
                super.setProperty(n, new Integer(n2));
                break;
            }
            case 7: {
                int n3;
                if (object == null) {
                    n3 = 1;
                    while (n3 <= this.cTable.rowCount) {
                        try {
                            if (!this.cTable.rowDeleted(n3)) {
                                Object object2 = this.getByRow(n3);
                                if (object == null) {
                                    object = object2;
                                } else {
                                    int n4 = ((Number)object).intValue();
                                    int n5 = ((Number)object2).intValue();
                                    if (n5 >= n4) {
                                        object = new Integer(n5 + 1);
                                    }
                                }
                            }
                        }
                        catch (SQLException sQLException) {
                            System.out.println(sQLException.toString());
                        }
                        ++n3;
                    }
                    if (object == null) {
                        object = new Integer(1000);
                    }
                }
                this.nextIncrement = n3 = ((Number)object).intValue();
                break;
            }
            default: {
                super.setProperty(n, object);
            }
        }
    }

    void write(RandomAccessFile randomAccessFile) throws IOException {
        super.write(randomAccessFile);
        randomAccessFile.writeBoolean(this.autoIncrement);
        randomAccessFile.writeInt(this.nextIncrement);
    }

    void close(RandomAccessFile randomAccessFile) throws IOException {
        super.close(randomAccessFile);
        randomAccessFile.writeBoolean(this.autoIncrement);
        randomAccessFile.writeInt(this.nextIncrement);
    }

    void read(RandomAccessFile randomAccessFile) throws IOException {
        super.read(randomAccessFile);
        this.autoIncrement = randomAccessFile.readBoolean();
        this.nextIncrement = randomAccessFile.readInt();
        if (this.autoIncrement) {
            this.requiresRecovery = true;
        }
    }

    void recover(Object object) {
        int n = (Integer)object;
        if (n >= this.nextIncrement) {
            this.nextIncrement = n + 1;
        }
    }

    Object toObject(Object object) {
        Integer n;
        if (this.autoIncrement && !this.cTable.noAutoInc && !this.cTable.autoIncOff) {
            return new Integer(this.nextIncrement++);
        }
        if (object == null) {
            return this.nullObj;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() == 0) {
                return this.nullObj;
            }
            try {
                n = ByteColumn.getInteger(string);
            }
            catch (Exception exception) {
                return null;
            }
        } else if (object instanceof Number) {
            int n2 = ((Number)object).intValue();
            n = ByteColumn.getInteger(n2);
        } else {
            return null;
        }
        int n3 = n;
        if (n3 == Integer.MIN_VALUE && !this.allowAccidentalNulls) {
            return null;
        }
        if (n3 > this.nextIncrement) {
            this.nextIncrement = n3 + 1;
        }
        return n;
    }

    void writeObject(idbDataOutputStream idbDataOutputStream2, Object object, Transaction transaction, int n) throws IOException {
        int n2 = (Integer)object;
        idbDataOutputStream2.writeInt(n2);
    }

    /*
     * Unable to fully structure code
     */
    public String toString(Object var1_1) {
        block3: {
            block4: {
                block2: {
                    var3_2 = ((Number)var1_1).intValue();
                    if (var3_2 != -2147483648) break block2;
                    var2_3 = "NULL";
                    break block3;
                }
                var4_4 = this.dbase.getStringBuffer();
                v0 = var5_5 = var3_2 < 0;
                if (!var5_5) break block4;
                var3_2 = -var3_2;
                ** GOTO lbl17
            }
            if (var3_2 >= 10) ** GOTO lbl17
            return IntegerColumn.strCache[var3_2];
lbl-1000:
            // 1 sources

            {
                var4_4.append(IntegerColumn.digits[var3_2 % 10]);
                var3_2 /= 10;
lbl17:
                // 3 sources

                ** while (var3_2 >= 10)
            }
lbl18:
            // 1 sources

            var4_4.append(IntegerColumn.digits[var3_2 % 10]);
            if (var5_5) {
                var4_4.append('-');
            }
            var2_3 = var4_4.reverse().toString();
            this.dbase.returnStringBuffer(var4_4);
        }
        return var2_3;
    }

    Object getByRow(int n) throws SQLException {
        Object object = super.getByRow(n);
        if (object == null) {
            try {
                int n2 = this.cTable.dataIn.readInt();
                this.cTable.freeReadAhead();
                object = new Integer(n2);
            }
            catch (Exception exception) {
                throw new SQLException("IO problem: " + exception.toString() + exception.getMessage());
            }
            this.rowCache.add(object, n);
        }
        return object;
    }

    private boolean equalToRow(int n, Number number) throws SQLException {
        int n2 = number.intValue();
        Object object = super.getByRow(n);
        if (object == null) {
            try {
                int n3 = this.cTable.dataIn.readInt();
                this.cTable.freeReadAhead();
                if (n3 != n2) {
                    return false;
                }
            }
            catch (Exception exception) {
                throw new SQLException("IO problem: " + exception.toString() + exception.getMessage());
            }
            return true;
        }
        return (Integer)object == n2;
    }

    boolean numeric() {
        return true;
    }

    boolean hashPreservesOrder() {
        return true;
    }

    int getHash(Object object) {
        Number number = (Number)object;
        return number.intValue();
    }

    static boolean compareVals(Object object, Object object2, int n, boolean bl) throws SQLException {
        int n2 = ((Number)object).intValue();
        int n3 = ((Number)object2).intValue();
        boolean bl2 = false;
        switch (n) {
            case 1: {
                bl2 = n2 == n3;
                break;
            }
            case 4: {
                bl2 = n2 != n3;
                break;
            }
            case 7: {
                bl2 = n2 < n3;
                break;
            }
            case 8: {
                bl2 = n2 <= n3;
                break;
            }
            case 5: {
                bl2 = n2 > n3;
                break;
            }
            case 6: {
                bl2 = n2 >= n3;
                break;
            }
            default: {
                throw new SQLException("Internal error: undefined operation: " + n, "XOPEN?");
            }
        }
        if (bl2 && !bl && (n2 == Integer.MIN_VALUE || n3 == Integer.MIN_VALUE)) {
            return false;
        }
        return bl2;
    }

    boolean compare(int n, Object object, int n2, boolean bl) throws SQLException {
        if (n2 == 1) {
            if (this.equalToRow(n, (Number)object)) {
                if (bl) {
                    return true;
                }
                return IntegerColumn.compareVals(this.getByRow(n), object, n2, bl);
            }
            return false;
        }
        return IntegerColumn.compareVals(this.getByRow(n), object, n2, bl);
    }

    IntegerColumn(Table table, String string) throws SQLException, NumberFormatException {
        super(table, string, 4);
        this.nullObj = new Integer(Integer.MIN_VALUE);
        this.nextIncrement = 1000;
        this.type = 2;
    }

    static {
        digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        strCache = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
    }
}

