/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.ResultSet;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class SQLBuilder
extends JPanel {
    static JFrame frame;
    static SQLBuilder panel;
    static final int WIDTH = 640;
    static final int HEIGHT = 520;
    JTabbedPane tabs;
    JLabel statusBar;
    ConnectionPanel connectPanel;
    QueryPanel qPanel;
    dbmdPanel dbmd;
    rsmdPanel rsmd;
    String[] landfNames;
    String[] landfClassNames;
    JRadioButton[] landfButtons;

    JRadioButton addButton(String string, ButtonGroup buttonGroup, String string2, ActionListener actionListener) {
        JRadioButton jRadioButton = new JRadioButton(string);
        jRadioButton.setActionCommand(string2);
        buttonGroup.add(jRadioButton);
        this.add(jRadioButton);
        jRadioButton.addActionListener(actionListener);
        return jRadioButton;
    }

    JLabel getStatusBar() {
        return this.statusBar;
    }

    JFrame getFrame() {
        return frame;
    }

    void onConnect(Connection connection) {
        this.qPanel.onConnect(connection);
        this.dbmd.onConnect(connection);
    }

    void onQuery(ResultSet resultSet) {
        this.rsmd.onQuery(resultSet);
    }

    public void updateState() {
        String string = UIManager.getLookAndFeel().getName();
        int n = 0;
        while (n < this.landfClassNames.length) {
            if (this.landfNames[n].equals(string)) {
                this.landfButtons[n].setSelected(true);
                break;
            }
            ++n;
        }
    }

    public static void main(String[] stringArray) {
        frame = new JFrame("ICS SQLBuilder");
        panel = new SQLBuilder();
        frame.addWindowListener(new WindowEventHandler(panel));
        frame.getContentPane().add("North", panel);
        frame.getContentPane().add("Center", SQLBuilder.panel.tabs);
        frame.getContentPane().add("South", SQLBuilder.panel.statusBar);
        frame.setSize(640, 520);
        frame.setVisible(true);
        panel.updateState();
    }

    public SQLBuilder() {
        ButtonGroup buttonGroup = new ButtonGroup();
        SQLBuilder sQLBuilder = this;
        if (sQLBuilder == null) {
            throw null;
        }
        RadioListener radioListener = sQLBuilder.new RadioListener();
        this.statusBar = new JLabel("Disconnected");
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        this.landfNames = new String[lookAndFeelInfoArray.length];
        this.landfClassNames = new String[lookAndFeelInfoArray.length];
        this.landfButtons = new JRadioButton[lookAndFeelInfoArray.length];
        int n = 0;
        while (n < lookAndFeelInfoArray.length) {
            this.landfNames[n] = lookAndFeelInfoArray[n].getName();
            this.landfClassNames[n] = lookAndFeelInfoArray[n].getClassName();
            this.landfButtons[n] = this.addButton(this.landfNames[n], buttonGroup, this.landfClassNames[n], radioListener);
            ++n;
        }
        this.tabs = new JTabbedPane();
        this.connectPanel = new ConnectionPanel(this);
        this.dbmd = new dbmdPanel(this);
        this.qPanel = new QueryPanel(this);
        this.rsmd = new rsmdPanel(this);
        this.tabs.addTab("Connection", null, this.connectPanel, "Connects/Disconnects to a database");
        this.tabs.addTab("Dbase Data", null, this.dbmd, "Database Meta-data");
        this.tabs.addTab("Query", null, this.qPanel, "Performs database queries");
        this.tabs.addTab("Results Data", null, this.rsmd, "Result Set Meta-data");
        this.tabs.setSelectedIndex(0);
    }

    class RadioListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            try {
                UIManager.setLookAndFeel(string);
                SwingUtilities.updateComponentTreeUI(frame);
                frame.setSize(640, 520);
            }
            catch (Exception exception) {
                JRadioButton jRadioButton = (JRadioButton)actionEvent.getSource();
                jRadioButton.setEnabled(false);
                System.err.println("Could not load LookAndFeel: " + string);
            }
            SQLBuilder.this.updateState();
        }

        RadioListener() {
        }
    }
}

