/*
 * Decompiled with CFR 0.152.
 */
package de.ix.jspTutorial.model;

import de.ix.jspTutorial.database.DatabaseGenericObject;
import de.ix.jspTutorial.model.Customer;
import de.ix.jspTutorial.model.Ingredient;
import de.ix.jspTutorial.model.PersonalPizza;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Order {
    public static String vcid = "$Id:$";
    private long id;
    private double price;
    private Customer customer;
    private PersonalPizza pizza;

    public Order() {
        this.customer = null;
        this.pizza = null;
        this.id = -1L;
        this.price = -1.0;
    }

    public Order(long l, Customer customer, PersonalPizza personalPizza, double d) {
        this.id = l;
        this.customer = customer;
        this.pizza = personalPizza;
        this.price = d;
    }

    public Customer getCustomer() {
        return this.customer;
    }

    public DatabaseGenericObject getGenericObject() {
        DatabaseGenericObject databaseGenericObject = new DatabaseGenericObject();
        databaseGenericObject.putValue("id", new Long(this.getId()));
        databaseGenericObject.putValue("price", new Double(this.getPrice()));
        databaseGenericObject.putValue("customerid", new Long(this.getCustomer().getId()));
        return databaseGenericObject;
    }

    public long getId() {
        return this.id;
    }

    public List getIngredientGenericObjects() {
        ArrayList<DatabaseGenericObject> arrayList = new ArrayList<DatabaseGenericObject>();
        Iterator iterator = this.pizza.getIngredients().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Ingredient ingredient = (Ingredient)entry.getValue();
            DatabaseGenericObject databaseGenericObject = ingredient.getGenericObject();
            databaseGenericObject.putValue("pizzaorderid", new Long(this.getId()));
            arrayList.add(databaseGenericObject);
            System.out.println("Ingredient " + databaseGenericObject);
        }
        return arrayList;
    }

    public PersonalPizza getPersonalPizza() {
        return this.pizza;
    }

    public DatabaseGenericObject getPizzaGenericObject() {
        DatabaseGenericObject databaseGenericObject = this.pizza.getPizza().getGenericObject();
        databaseGenericObject.putValue("pizzaorderid", new Long(this.getId()));
        return databaseGenericObject;
    }

    public double getPrice() {
        return this.price;
    }

    public void setCustomer(Customer customer) {
        this.customer = this.customer;
    }

    public void setId(long l) {
        this.id = l;
    }

    public void setPizza(PersonalPizza personalPizza) {
        this.pizza = personalPizza;
    }

    public void setPrice(double d) {
        this.price = d;
    }

    public String toString() {
        return "Customer: " + this.customer + "  id: " + this.id + "  price: " + this.price + " pizza " + this.pizza;
    }
}

