/*
 * Decompiled with CFR 0.152.
 */
package de.ix.jspTutorial.database;

import de.ix.jspTutorial.database.DatabaseException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Properties;

public class DatabaseConnection {
    public static String vcid = "$Id:$";
    private String myDatabaseDriver;
    private String myConnectionString;
    private String myDescription;
    private boolean myIsConnected = false;
    private Connection myConnection;
    private Properties myProperties;
    private long myLastUsed;

    private DatabaseConnection() {
    }

    public DatabaseConnection(String string, String string2) throws DatabaseException {
        this(string, string2, "no description");
    }

    public DatabaseConnection(String string, String string2, String string3) throws DatabaseException {
        this.myDatabaseDriver = string;
        this.myConnectionString = string2;
        this.myDescription = string3;
        try {
            Class.forName(this.myDatabaseDriver);
        }
        catch (Exception exception) {
            throw new DatabaseException("Can't load Database Driver " + this.myDatabaseDriver);
        }
        this.myConnection = null;
        this.myIsConnected = false;
        this.used();
    }

    public synchronized boolean begin() throws DatabaseException {
        return this.isConnected();
    }

    public synchronized void commit() throws DatabaseException {
        if (!this.isConnected()) {
            return;
        }
        try {
            this.myConnection.commit();
        }
        catch (SQLException sQLException) {
            throw new DatabaseException("Could not commit (" + this.myDescription + ")", sQLException);
        }
        this.used();
    }

    public synchronized void connect(String string, String string2) throws DatabaseException {
        Properties properties = new Properties();
        ((Hashtable)properties).put("user", string);
        ((Hashtable)properties).put("password", string2);
        this.connect(properties);
    }

    public synchronized void connect(Properties properties) throws DatabaseException {
        if (this.myConnection != null) {
            try {
                this.disconnect();
            }
            catch (DatabaseException databaseException) {}
        }
        try {
            this.myProperties = properties;
            this.myConnection = DriverManager.getConnection(this.myConnectionString, this.myProperties);
            if (this.myConnection == null) {
                throw new DatabaseException("Can't get connection to database via driver '" + this.myDatabaseDriver + "' and server " + this.myConnectionString + "JDBC returned a null connection. (" + this.myDescription + ")");
            }
            this.setAutoCommit(false);
        }
        catch (SQLException sQLException) {
            if (this.myConnection != null) {
                try {
                    this.myConnection.close();
                }
                catch (SQLException sQLException2) {}
            }
            this.myConnection = null;
            throw new DatabaseException("Can't get connection to database via driver '" + this.myDatabaseDriver + "' and server " + this.myConnectionString + "' (" + this.myDescription + ")", sQLException);
        }
        this.myIsConnected = true;
        this.used();
    }

    public Statement createStatement() throws SQLException {
        if (this.isConnected()) {
            return this.myConnection.createStatement();
        }
        return null;
    }

    public synchronized void disconnect() throws DatabaseException {
        try {
            try {
                if (this.myConnection != null) {
                    this.myConnection.close();
                }
            }
            catch (SQLException sQLException) {
                throw new DatabaseException("Can't disconnect to database via driver '" + this.myDatabaseDriver + "' and server " + this.myConnectionString + "JDBC returned a null connection. (" + this.myDescription + ")", sQLException);
            }
            Object var2_2 = null;
            this.myConnection = null;
            this.myIsConnected = false;
            this.used();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.myConnection = null;
            this.myIsConnected = false;
            this.used();
            throw throwable;
        }
    }

    public void finalize() {
        block2: {
            if (!this.isConnected()) break block2;
            try {
                this.disconnect();
            }
            catch (DatabaseException databaseException) {
                databaseException.printStackTrace();
            }
        }
    }

    public synchronized boolean getAutoCommit() throws SQLException {
        if (this.isConnected()) {
            return this.myConnection.getAutoCommit();
        }
        return false;
    }

    public String getConnectionString() {
        return this.myConnectionString;
    }

    public String getDatabaseDriver() {
        return this.myDatabaseDriver;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public long getLastUsed() {
        return this.myLastUsed;
    }

    public String getLogin() {
        return this.myProperties.getProperty("user");
    }

    public String getPassword() {
        return this.myProperties.getProperty("password");
    }

    public boolean isConnected() {
        return this.myIsConnected;
    }

    public String nativeSQL(String string) throws SQLException {
        if (this.isConnected()) {
            return this.myConnection.nativeSQL(string);
        }
        return null;
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        if (this.isConnected()) {
            return this.myConnection.prepareCall(string);
        }
        return null;
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        if (this.isConnected()) {
            return this.myConnection.prepareStatement(string);
        }
        return null;
    }

    public synchronized void rollback() throws DatabaseException {
        if (!this.isConnected()) {
            return;
        }
        try {
            this.myConnection.rollback();
        }
        catch (SQLException sQLException) {
            throw new DatabaseException("Could not rollback (" + this.myDescription + ")", sQLException);
        }
        this.used();
    }

    public synchronized void setAutoCommit(boolean bl) throws SQLException {
        if (this.isConnected()) {
            this.myConnection.setAutoCommit(bl);
        }
    }

    public synchronized void setDescription(String string) {
        if (string != null) {
            this.myDescription = string;
        }
        this.used();
    }

    private void used() {
        this.myLastUsed = System.currentTimeMillis();
    }
}

