package de.ebuchner.jv;

import java.util.*;
import java.util.jar.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.table.*;
import java.awt.*;

/**
 * Das Panel zeigt Infos ueber ein Manifest-File
 */
public class ManifestPanel extends JPanel {
  Border border1;
  TitledBorder titledBorder1;
  Border border2;
  JScrollPane mainScroller = new JScrollPane();

  JTable mainAttribs;
  ManifestModel mainModel, classModel;
  JPanel mainPanel = new JPanel();
  BorderLayout borderLayout2 = new BorderLayout();
  JPanel classPanel = new JPanel();
  GridLayout gridLayout1 = new GridLayout();
  JScrollPane classScroller = new JScrollPane();
  BorderLayout borderLayout1 = new BorderLayout();
  JTable classAttribs;
  TitledBorder titledBorder2;
  Border border3;
  TitledBorder titledBorder3;

  /**
   * Zeigt Meta-Informationen an zu einem Element im Archiv
   */
  public void show(Manifest manifest, JarEntry entry) {
    show(manifest);

    Attributes attributes = ManifestModel.DEF_ATTRIBS;

    if(entry!=null && manifest!=null) {
      Attributes a = manifest.getAttributes(entry.getName());
      if(a!=null)
        attributes=a;
    }

    classModel.setAttributes(attributes);
  }

  /**
   * Zeigt allgemeine Meta-Informationen an
   */
  public void show(Manifest manifest) {
    if(manifest!=null)
      mainModel.setAttributes(manifest.getMainAttributes());
    else
      mainModel.setAttributes(ManifestModel.DEF_ATTRIBS);
  }

  /**
   * C'tor (JBuilder-like)
   */
  public ManifestPanel() {
    try  {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    mainAttribs = new JTable(mainModel = new ManifestModel());
    classAttribs = new JTable(classModel = new ManifestModel());

    border2 = new TitledBorder(BorderFactory.createEmptyBorder(5,5,5,5),"Manifest File");
    titledBorder1 = new TitledBorder(border1,"Manifest File");
    border1 = BorderFactory.createEtchedBorder(Color.white,new java.awt.Color(149, 142, 130));
    titledBorder2 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white,new java.awt.Color(149, 142, 130)),"Class Attributes");
    border3 = new EtchedBorder(EtchedBorder.RAISED,Color.white,new java.awt.Color(149, 142, 130));
    titledBorder3 = new TitledBorder(border3,"Main Attributes");
    this.setLayout(gridLayout1);
    mainPanel.setLayout(borderLayout2);
    gridLayout1.setColumns(1);
    gridLayout1.setHgap(5);
    gridLayout1.setRows(2);
    gridLayout1.setVgap(5);
    classPanel.setLayout(borderLayout1);
    classPanel.setBorder(titledBorder2);
    mainPanel.setBorder(titledBorder3);
    this.add(mainPanel, null);
    mainPanel.add(mainScroller, BorderLayout.CENTER);
    this.add(classPanel, null);
    classPanel.add(classScroller, BorderLayout.CENTER);
    classScroller.getViewport().add(classAttribs, null);
    mainScroller.getViewport().add(mainAttribs, null);
  }

}

/**
 * Manifest-Eintraege liegen als Key-Value-Paare vor.
 * Dieses Model verwaltet die Info zur Anzeige in
 * einer JTable
 */
class ManifestModel extends AbstractTableModel {

  private String[] columnNames = {
    "Attribute Name", "Value"
  };

  static Attributes DEF_ATTRIBS = new Attributes();

  Attributes attribs;
  Object[] keys;

  // Indizes
  public static final int ATTRIB_NAME=0;
  public static final int ATTRIB_VALUE=1;

  /**
   * Konstruktor
   */
  public ManifestModel() {
    setAttributes(DEF_ATTRIBS);
  }

  /**
   * neue Daten
   */
  public void setAttributes(Attributes attribs) {
    this.attribs=attribs;
    keys = attribs.keySet().toArray();
    // Listener benachrichtigen
    fireTableDataChanged();
  }

  /**
   * Spaltenzahl
   */
  public int getColumnCount() {
    return columnNames.length;
  }

  /**
   * Zeilenzahl
   */
  public int getRowCount() {
    return attribs.size();
  }

  /**
   * Spaltenueberschriften
   */
  public String getColumnName(int col) {
    return columnNames[col];
  }

  /**
   * Datenelemente
   */
  public Object getValueAt(int row, int col) {
    if(row<0 || row>=attribs.size())
      throw new IllegalArgumentException("Invalid row " + row);

    switch(col) {
      case ATTRIB_NAME:
        return keys[row];
      case ATTRIB_VALUE:
        return attribs.get(keys[row]);
    }
    throw new IllegalArgumentException("Invalid column " + col);
  }

  /*
   * Flag fuer Renderer/Editoren
   */
  public Class getColumnClass(int col) {
    return String.class;
  }

  /*
   * Welche Zellen sind editierbar?
   */
  public boolean isCellEditable(int row, int col) {
    return false;
  }
  /*
   * Zelle wurde editiert
   */
  public void setValueAt(Object value, int row, int col) {
    throw new RuntimeException("Attributes cannot be edited");
  }
}
