package de.ebuchner.je;

import java.awt.dnd.*;
import java.io.*;
import java.util.*;

import de.ebuchner.datatransfer.FileSelection;
import de.ebuchner.dnd.DragSourceAdapter;

/**
 * Dieser DragGestureRecognizer wird informiert, wenn der
 * Benutzer eine Datei aus JExplorer zu ziehen beginnt
 * <p>
 * Wird eine Drag-Geste erkannt, erzeugt dieser Adapter
 * das Datenobjekt, das dem DnD-System bergeben wird.
 */
public class JeDGAdapter implements DragGestureListener {

  // Welche DragActions unterstuetzt dieser Adapter
  final int dragActions = DnDConstants.ACTION_COPY_OR_MOVE;

  public JeDGAdapter(FileTable table) {

    // DragGestureRecognizer initialisieren
    DragSource dragSource = DragSource.getDefaultDragSource();
    dragSource.createDefaultDragGestureRecognizer(
      table,
      dragActions,
      this
    );
  }

  /**
   * Eine Drag-Geste wurde erkannt
   */
  public void dragGestureRecognized(DragGestureEvent dge) {
    // Nur bestimmte Aktionen zulassen
    if((dge.getDragAction() & dragActions) == 0)
      return;

    // Alle markierten Objekte der Tabelle
    FileTable table = (FileTable)dge.getComponent();
    File [] selFiles = table.getSelectedFiles();
    if(selFiles==null || selFiles.length==0) // nichts selektiert
      return;

    FileSelection fsel = new FileSelection(selFiles);

    dge.startDrag(
      DragSource.DefaultCopyNoDrop,
      fsel,
      new DragSourceAdapter()
    );
  }
}

