package de.ebuchner.je;

import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.text.*;
import java.util.Date;
import javax.swing.*;
import javax.swing.table.*;

/**
 * Dateiliste (JTable)
 */
public class FileTable extends JTable {

  public FileTable() {
    super(new FileTableModel());

    // Anzeige Name, Groesse und Datum
    setDefaultRenderer(File.class, new NameRenderer());
    setDefaultRenderer(Long.class, new SizeRenderer());
    setDefaultRenderer(Date.class, new DateRenderer());
    setGridColor(getBackground());
  }

  /**
   * Zeigt den Inhalt eines Verzeichnisses
   */
  public void setCwd(File dir) {
    FileTableModel model = (FileTableModel)getModel();
    model.setCwd(dir);
  }

  /**
   * @return Liste der markierten Dateien (evtl. leer)
   */
  public File [] getSelectedFiles() {
    FileTableModel model = (FileTableModel)getModel();
    int [] sel = getSelectedRows();
    File [] selFiles = new File[sel.length];

    for(int i=0; i<sel.length; i++) {
      selFiles[i] = model.getFileAt(sel[i]);
    }
    return selFiles;
  }
}

/**
 * Anzeige Dateiname
 */
class NameRenderer extends DefaultTableCellRenderer {

  public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
    File f = (File)value;

    return super.getTableCellRendererComponent(
      table, JeUtils.nameOf(f), isSelected, hasFocus, row, column);
  }
}

/**
 * Anzeige Dateigroesse
 */
class SizeRenderer extends DefaultTableCellRenderer {
  NumberFormat fmt;

  public SizeRenderer() {
    fmt = NumberFormat.getNumberInstance();
    fmt.setGroupingUsed(true);
    fmt.setParseIntegerOnly(true);
    this.setHorizontalAlignment(RIGHT);
  }

  public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
    String s="n/a";
    if(value!=null) {
      long size = ((Long)value).longValue();
      s = fmt.format(size).toString();
    }

    return super.getTableCellRendererComponent(table, s, isSelected, hasFocus, row, column);
  }
}

/**
 * Anzeige Datum
 */
class DateRenderer extends DefaultTableCellRenderer {
  DateFormat fmt;

  public DateRenderer() {
    fmt = DateFormat.getDateTimeInstance(DateFormat.SHORT, DateFormat.SHORT);
    this.setHorizontalAlignment(RIGHT);
  }

  public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
    String s = "n/a";
    if(value!=null)
      s = fmt.format(value).toString();

    return super.getTableCellRendererComponent(table, s, isSelected, hasFocus, row, column);
  }
}
