package de.ebuchner.je;

import java.awt.*;
import java.awt.event.*;
import java.net.URL;
import javax.swing.*;

import javax.swing.border.*;

/**
 * JExplorer Aboutbox
 */
public class AboutBox extends JDialog {
  BorderLayout borderLayout1 = new BorderLayout();
  JPanel dlgPanel = new JPanel();
  GridBagLayout gridBagLayout = new GridBagLayout();
  JLabel programName = new JLabel();
  JLabel version = new JLabel();
  JLabel copyright = new JLabel();
  JLabel urltext = new JLabel();
  JLabel jversion = new JLabel();
  JButton btnClose = new JButton();

  public AboutBox(Frame frame) {
    super(frame, "JExplorer Info", true);

    try  {
      jbInit();
      pack();
    }
    catch(Exception ex) {
      ex.printStackTrace();
    }
  }

  /**
   * Dieser Code wurde mit JBuilder GUI-Designer generiert und sollte
   * mit diesem editierbar bleiben! Modifikationen soweit moeglich
   * mit dem Designer!
   */
  void jbInit() throws Exception {

    // Dialog
    dlgPanel.setLayout(gridBagLayout);

    // Programm
    programName.setFont(new java.awt.Font("Serif", 1, 18));
    programName.setForeground(Color.black);
    programName.setText("JExplorer");

    // Version
    version.setFont(new java.awt.Font("SansSerif", 1, 12));
    version.setForeground(Color.black);
    version.setText("Version 0.1");

    // Java Version
    jversion.setFont(new java.awt.Font("SansSerif", 1, 12));
    jversion.setForeground(Color.black);
    jversion.setText("Java " + System.getProperty("java.version"));

    // Copyright
    copyright.setFont(new java.awt.Font("SansSerif", 1, 12));
    copyright.setForeground(Color.black);
    copyright.setText("(no copyrights)");

    // URL
    urltext.setFont(new java.awt.Font("SansSerif", 1, 12));
    urltext.setForeground(Color.blue);
    urltext.setBorder(BorderFactory.createMatteBorder(0,0,1,0,Color.blue));
    urltext.setText("http://www.ebuchner.de");
    urltext.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));

    // Logo
    //logo.setPreferredSize(new Dimension(32, 32));

    // Close-Button
    btnClose.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        AboutBox.this.dispose();
      }
    });
    btnClose.setText("Close");

    // Panel
    getContentPane().add(dlgPanel);
    dlgPanel.add(programName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.NORTH, GridBagConstraints.NONE, new Insets(5, 5, 10, 10), 0, 0));
    dlgPanel.add(version, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.NORTHEAST, GridBagConstraints.NONE, new Insets(5, 5, 0, 10), 0, 0));
    dlgPanel.add(copyright, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.NORTHEAST, GridBagConstraints.NONE, new Insets(5, 5, 0, 10), 0, 0));
    dlgPanel.add(jversion, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.NORTHEAST, GridBagConstraints.NONE, new Insets(5, 5, 0, 10), 0, 0));
    dlgPanel.add(urltext, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0
            ,GridBagConstraints.NORTH, GridBagConstraints.NONE, new Insets(5, 5, 5, 10), 0, 0));
    dlgPanel.add(btnClose, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.5
            ,GridBagConstraints.SOUTHEAST, GridBagConstraints.NONE, new Insets(15, 5, 5, 10), 0, 0));

    // Ok-Btn = Default
    JRootPane rp = getRootPane();
    rp.setDefaultButton(btnClose);

    // ESC-Key entspricht Cancel-Button
    KeyStroke escStroke = KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0);
    ActionListener escListener = new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        btnClose.doClick();
      }
    };
    rp.registerKeyboardAction(escListener, escStroke, JComponent.WHEN_IN_FOCUSED_WINDOW);

  }

}

