/*
 * Decompiled with CFR 0.152.
 */
package de.ebuchner.jv;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.jar.JarEntry;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class JvEntryPanel
extends JPanel {
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JLabel lbSize = new JLabel();
    JTextField tfSize = new JTextField();
    JLabel lbCompressed = new JLabel();
    JTextField tfCompressed = new JTextField();
    JLabel lbTime = new JLabel();
    JTextField tfTime = new JTextField();
    JLabel lbComment = new JLabel();
    JTextArea taComment = new JTextArea();
    JScrollPane scrollPane1 = new JScrollPane();
    DateFormat dtef = DateFormat.getDateTimeInstance(3, 3);
    DecimalFormat intf = new DecimalFormat("#,##0");
    DecimalFormat prcf = new DecimalFormat("#.0%");

    public JvEntryPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.lbSize.setText("Size:");
        this.tfSize.setEditable(false);
        this.tfSize.setColumns(10);
        this.tfSize.setHorizontalAlignment(4);
        this.lbCompressed.setText("Compressed:");
        this.tfCompressed.setEditable(false);
        this.tfCompressed.setColumns(10);
        this.tfCompressed.setHorizontalAlignment(4);
        this.lbTime.setText("Time:");
        this.tfTime.setEditable(false);
        this.tfTime.setColumns(10);
        this.tfTime.setHorizontalAlignment(4);
        this.lbComment.setText("Comment:");
        this.taComment.setLineWrap(true);
        this.taComment.setColumns(30);
        this.taComment.setRows(2);
        this.taComment.setEditable(false);
        this.add((Component)this.lbSize, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.tfSize, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.lbCompressed, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.tfCompressed, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.lbTime, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.tfTime, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.lbComment, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.scrollPane1, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.scrollPane1.getViewport().add((Component)this.taComment, null);
    }

    public void show(JarEntry jarEntry) {
        long l;
        long l2 = jarEntry.getSize();
        if (l2 > 0L) {
            this.tfSize.setText(this.intf.format(l2));
            l = jarEntry.getCompressedSize();
            if (l == l2) {
                this.tfCompressed.setText("(not compressed)");
            } else {
                this.tfCompressed.setText(this.prcf.format((double)l / (double)l2));
            }
        } else {
            this.tfSize.setText("");
            this.tfCompressed.setText("");
        }
        l = jarEntry.getTime();
        if (l > 0L) {
            this.tfTime.setText(this.dtef.format(new Date(l)));
        } else {
            this.tfTime.setText("");
        }
        String string = jarEntry.getComment();
        if (string != null) {
            this.taComment.setText(string);
        } else {
            this.taComment.setText("");
        }
    }
}

