/*
 * Decompiled with CFR 0.152.
 */
package de.ebuchner.jar;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public final class JarUtils {
    private static String TMPDIR = System.getProperty("java.io.tmpdir");

    static {
        if (!TMPDIR.endsWith(File.separator)) {
            TMPDIR = String.valueOf(TMPDIR) + File.separatorChar;
        }
    }

    public static File extract(JarFile jarFile, JarEntry jarEntry) throws IOException {
        File file = JarUtils.genTmpFile(jarFile, jarEntry);
        return JarUtils.extract(jarFile, jarEntry, file);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File extract(JarFile jarFile, JarEntry jarEntry, File file) throws IOException {
        File file2;
        FileOutputStream fileOutputStream;
        block4: {
            InputStream inputStream = null;
            fileOutputStream = null;
            try {
                int n;
                inputStream = jarFile.getInputStream(jarEntry);
                fileOutputStream = new FileOutputStream(file);
                byte[] byArray = new byte[1024];
                while ((n = inputStream.read(byArray)) > 0) {
                    ((OutputStream)fileOutputStream).write(byArray, 0, n);
                }
                file2 = file;
                Object var7_8 = null;
                if (inputStream == null) break block4;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (inputStream != null) {
                    inputStream.close();
                }
                if (fileOutputStream == null) throw throwable;
                ((OutputStream)fileOutputStream).close();
                throw throwable;
            }
            inputStream.close();
        }
        if (fileOutputStream == null) return file2;
        ((OutputStream)fileOutputStream).close();
        return file2;
    }

    private static File genTmpFile(JarFile jarFile, JarEntry jarEntry) {
        File file;
        String string = JarUtils.nameOf(jarEntry);
        String string2 = JarUtils.pathOf(jarEntry);
        if (string2.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer(TMPDIR).append(string2);
            File file2 = new File(stringBuffer.toString());
            if (!file2.exists()) {
                file2.mkdirs();
            }
            file = new File(file2, string);
        } else {
            file = new File(TMPDIR, string);
        }
        file.deleteOnExit();
        return file;
    }

    public static String nameOf(JarEntry jarEntry) {
        Enumeration enumeration = JarUtils.splitName(jarEntry);
        String string = null;
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
        }
        return string;
    }

    public static String pathOf(JarEntry jarEntry) {
        Enumeration enumeration = JarUtils.splitName(jarEntry);
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!enumeration.hasMoreElements()) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(File.separatorChar);
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static Enumeration splitName(JarEntry jarEntry) {
        StringTokenizer stringTokenizer = new StringTokenizer(jarEntry.getName(), "/");
        return stringTokenizer;
    }
}

