package de.ebuchner.je;

import java.io.File;
import java.util.*;

/**
 * File-Handling Utilities
 */
public final class JeUtils {

  public static final int TYPE_ALL = 0;
  public static final int TYPE_FILES = 1;
  public static final int TYPE_DIR = 2;

  /** Empty List */
  public static final File [] NO_FILES = new File[0];

  /** Comparator zum Sortieren der Dateinamen */
  static Comparator fileComparator = new Comparator() {
    public int compare(Object o1, Object o2) {
      File f1 = (File)o1;
      File f2 = (File)o2;
      return f1.compareTo(f2);
    }
  };

  /**
   * Dateiname
   */
  public static String nameOf(File f) {
    String fName = "My Computer";
    if(f!=null) {
      fName = f.getName();
      // NT: Laufwerke haben keinen Namen
      if(fName.length()==0)
        fName = f.getAbsolutePath();
    }
    return fName;
  }

  /**
   * Liefert einen bestimmten Typ von Files aus einer Liste
   */
  public static Object [] extract(Object [] fileObjs, int type, boolean sort, boolean showHidden) {
    ArrayList fileList = new ArrayList();
    for(int i=0; i<fileObjs.length; i++) {
      File fx = (File)fileObjs[i];

      boolean isDir = fx.isDirectory();
      boolean visible = !fx.isHidden() || showHidden;

      if(visible) {
        if (isDir && type==TYPE_DIR)
          fileList.add(fx);
        else if(!isDir && type==TYPE_FILES)
          fileList.add(fx);
        else if(type==TYPE_ALL)
          fileList.add(fx);
      }
    }
    Object [] files = fileList.toArray();
    if(sort && files.length>1)
      Arrays.sort(files, 0, files.length, fileComparator);
    return files;
  }

}
