package de.ebuchner.je;

import java.awt.*;
import java.io.File;
import javax.swing.*;
import javax.swing.event.*;

/**
 * "Director" der JExplorer GUI (see Gamma et al.)
 */
public class JeDirector implements TreeSelectionListener {
  JeFrame frame;
  DirTree tree;
  FileTable table;

  public JeDirector(JeFrame frame, DirTree tree, FileTable table) {
    this.frame=frame;
    this.tree=tree;
    this.table=table;

    tree.addTreeSelectionListener(this);

    new JeDGAdapter(table);
    new JeDTAdapter(tree, this);
    new JeDTAdapter(table, this);
  }

  public void valueChanged(TreeSelectionEvent e) {
    if(e.getSource()==tree) {
      File cwd = tree.getCwd();
      if(cwd==null) {
        frame.setStatus("");
        table.setCwd(null);
      }
      else {
        frame.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
        frame.setStatus(cwd.getAbsolutePath());
        table.setCwd(cwd);
        frame.setCursor(Cursor.getDefaultCursor());
      }
    }
  }

  public File getCwd() {
    return tree.getCwd();
  }

  // todo: Veraenderungen im Verzeichnisbaum
  public void refresh() {
    table.setCwd(tree.getCwd());
  }

  public void setHiddenShown(boolean hiddenShown) {
    // todo
  }
}
