package de.ebuchner.je;

import java.io.File;
import javax.swing.*;
import javax.swing.tree.*;

/**
 * Verzeichnis-Baum
 */
public class DirTree extends JTree {

  public DirTree() {
    super(new DirTreeModel());

    setRootVisible(false);
    setCellRenderer(new DirNodeRenderer());
    getSelectionModel().setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
    setShowsRootHandles(true);
    putClientProperty("JTree.lineStyle", "Angled");
  }

  /**
   * Liefert das aktuelle Verzeichnis aus der Selektion
   */
  public File getCwd() {
    TreePath tp = this.getLeadSelectionPath();
    if(tp==null)
      return null;

    DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)tp.getLastPathComponent();
    return (File)dmtn.getUserObject();
  }
}
