/*
 * Decompiled with CFR 0.152.
 */
package de.ebuchner.jv;

import de.ebuchner.jv.JvTree;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.util.List;
import java.util.zip.ZipException;

public class TreeDTAdapter
implements DropTargetListener {
    final int dropActions = 3;

    public TreeDTAdapter(JvTree jvTree) {
        new DropTarget(jvTree, 3, this);
    }

    private void checkDrag(DropTargetDragEvent dropTargetDragEvent) {
        boolean bl = dropTargetDragEvent.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
        int n = dropTargetDragEvent.getDropAction();
        if (bl && (n & 3) > 0) {
            dropTargetDragEvent.acceptDrag(n);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        this.checkDrag(dropTargetDragEvent);
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        this.checkDrag(dropTargetDragEvent);
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        JvTree jvTree = (JvTree)dropTargetDropEvent.getDropTargetContext().getComponent();
        if (dropTargetDropEvent.isLocalTransfer()) {
            System.err.println("Local transfer is not supported");
            dropTargetDropEvent.rejectDrop();
            return;
        }
        try {
            dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
            Transferable transferable = dropTargetDropEvent.getTransferable();
            List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
            if (list.size() != 1) {
                System.err.println("Only one archive may be opened");
                dropTargetDropEvent.dropComplete(false);
                return;
            }
            File file = (File)list.get(0);
            jvTree.show(file);
            dropTargetDropEvent.dropComplete(true);
        }
        catch (ZipException zipException) {
            System.err.println("Not a valid JAR file");
            dropTargetDropEvent.dropComplete(false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            dropTargetDropEvent.dropComplete(false);
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        this.checkDrag(dropTargetDragEvent);
    }
}

