/*
 * Decompiled with CFR 0.152.
 */
package de.ebuchner.jv;

import de.ebuchner.datatransfer.FileSelection;
import de.ebuchner.dnd.DragSourceAdapter;
import de.ebuchner.jar.JarUtils;
import de.ebuchner.jv.JvTree;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.io.IOException;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class TreeDGAdapter
implements DragGestureListener {
    final int dragActions = 3;

    public TreeDGAdapter(JvTree jvTree) {
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(jvTree, 3, this);
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        if ((dragGestureEvent.getDragAction() & 3) == 0) {
            return;
        }
        JvTree jvTree = (JvTree)dragGestureEvent.getComponent();
        JarEntry[] jarEntryArray = jvTree.getSelectionEntries();
        if (jarEntryArray == null) {
            return;
        }
        JarFile jarFile = jvTree.getJarFile();
        try {
            FileSelection fileSelection = new FileSelection();
            int n = 0;
            while (n < jarEntryArray.length) {
                JarEntry jarEntry = jarEntryArray[n];
                if (jarEntry != null) {
                    fileSelection.add(JarUtils.extract(jarFile, jarEntry));
                }
                ++n;
            }
            dragGestureEvent.startDrag(DragSource.DefaultCopyNoDrop, fileSelection, new DragSourceAdapter());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

