/*
 * Decompiled with CFR 0.152.
 */
package de.ebuchner.je;

import de.ebuchner.je.JeUtils;
import java.io.File;
import java.util.Date;
import javax.swing.table.AbstractTableModel;

public class FileTableModel
extends AbstractTableModel {
    private Object[] cwd = JeUtils.NO_FILES;
    private String[] colNames = new String[]{"Name", "Size", "Modified"};
    private Class[] colClasses = new Class[]{class$java$io$File != null ? class$java$io$File : (class$java$io$File = FileTableModel.class$("java.io.File")), class$java$lang$Long != null ? class$java$lang$Long : (class$java$lang$Long = FileTableModel.class$("java.lang.Long")), class$java$util$Date != null ? class$java$util$Date : (class$java$util$Date = FileTableModel.class$("java.util.Date"))};
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$util$Date;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Class getColumnClass(int n) {
        return this.colClasses[n];
    }

    public int getColumnCount() {
        return this.colNames.length;
    }

    public String getColumnName(int n) {
        return this.colNames[n];
    }

    public File getFileAt(int n) {
        return (File)this.getValueAt(n, 0);
    }

    public int getRowCount() {
        return this.cwd.length;
    }

    public Object getValueAt(int n, int n2) {
        File file = (File)this.cwd[n];
        try {
            switch (n2) {
                case 0: {
                    return file;
                }
                case 1: {
                    return new Long(file.length());
                }
                case 2: {
                    return new Date(file.lastModified());
                }
            }
            throw new IllegalArgumentException("No such column " + n2);
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public void setCwd(File file) {
        Object[] objectArray = null;
        if (file != null) {
            objectArray = file.listFiles();
        }
        if (objectArray == null) {
            objectArray = JeUtils.NO_FILES;
        } else {
            this.cwd = JeUtils.extract(objectArray, 1, true, false);
        }
        this.fireTableDataChanged();
    }

    public void setValueAt(Object object, int n, int n2) {
    }
}

