#!/usr/bin/python

# Einfaches Gaestebuchskript
# Tobias Himstedt

import gadfly
import cgi

# Formularstring
formString = """
<form action = "/cgi-bin-py/insertGuest.py">
<table>
<tr><th align = "right">Vorname
    <td align = "left"> <input type="text" name="vorname">
<tr><th align = "right">Nachname
    <td align = "left"> <input type="text" name="nachname">
<tr><th align = "right"> Email
    <td align = "left"> <input type="text" name="email">
</table>
<input type="submit" value="Eintragen">
<input type="reset" value="Loeschen">
</form>
"""

def printHeader():
    print "Content-type: text/html"     
    print                               
    print "<html><head><title>Gaestebuch</title></head><body>"

def printFooter():
    print "</body></html>"
        
def main():
    # Die Werte aus dem Form auslesen
    form = cgi.FieldStorage()
    if (not form.has_key("vorname") or form["vorname"].value == "") or \
       (not form.has_key("nachname") or form["nachname"].value == "") or \
       (not form.has_key("email") or form["email"].value == ""):

	# In diesem Fall wurde noch nichts oder nicht alles ins 
	# Formular eingetragen
        printHeader()                
        print "<H1>Bitte fuellen Sie alle Felder aus</h1>"
        print formString
        printFooter()        
        return
    else:
        # In diesem Fall sind Daten in das Formular eingetragen, diese
        # nun in Datenbank eintragen                
        # Verbindung aufmachen
        connection = gadfly.gadfly("ixdata", "ixdatadir")
        cursor = connection.cursor()
	# Werte auslesen
	vorname = form["vorname"].value
	nachname = form["nachname"].value
	email = form["email"].value                
	# Gibt es schon jemmanden mit diesem Vornamen/Nachnamen?
	cursor.execute("select id, vorname, nachname, email from "
		       "gaestebuch where vorname = ? and nachname = ?", 
		       (vorname, nachname))
	rows = cursor.fetchall()
	# Eintrag gefunden?
	if rows == []:
	    # Nichts gefunden, also neuen Eintrag in DB
	    # Zunaechst maximalen Wert fuer ID ermitteln
	    cursor.execute("select max(id) from gaestebuch")
	    id = cursor.fetchone()[0]
	    # Nun neuen eintrag in DB
	    cursor.execute("insert into gaestebuch(id, vorname, nachname, "
			   "email) values (?, ?, ?, ?)", 
			   (id+1, vorname, nachname, email))
	    printHeader()
	    print "<h1>Sie sind nun in unserem Gaestebuch verewigt</h1>"
	    printFooter()
	else:
	    # Ein Eintrag wurde gefunden, dann email-Adresse updaten
	    id = rows[0][0]
	    cursor.execute("update gaestebuch set email = ? where id = ?", 
			  (email, id))
	    printHeader()
	    print "<h1>Ihre Email-Adresse wurde aktualisiert</h1>"
	    printFooter()
	# Abschliessend noch ein commit auf der DB
	connection.commit()
	# Fertig

main()
