#! /local/bin/tclsh8.0

#
# cgi.tcl - Modul laden
# Siehe Homepage, http://expect.nist.gov/cgi.tcl
#

package require cgi

#
# Postgres-Modul laden
# Aus der PostgreSQL-Distribution, http://www.postgresql.org/
#

load /local/lib/libpgtcl80.so

#
# Formular ausgeben
#

proc show_form {} {
    global env Vorname Nachname Email

    cgi_form $env(SCRIPT_NAME) {
	cgi_table {
	    cgi_table_row {
		cgi_table_head align=right { cgi_puts [cgi_bold Vorname] }
		cgi_table_data align=left  { cgi_text Vorname size=25 }
	    }
	    cgi_table_row {
		cgi_table_head align=right { cgi_puts [cgi_bold Nachname] }
		cgi_table_data align=left  { cgi_text Nachname size=25 }
	    }
	    cgi_table_row {
		cgi_table_head align=right { cgi_puts [cgi_bold Email] }
		cgi_table_data align=left  { cgi_text Email size=60 }
	    }
	}
	cgi_submit_button =Eintragen
	cgi_reset_button Abbrechen
    }
}

#
# Setup
#

cgi_admin_mail_addr fp
cgi_suffix {}

#
# CGI-Daten auswerten
#

catch {cgi_input}
if {[catch {cgi_import Vorname}]}  { set Vorname "" }
if {[catch {cgi_import Nachname}]} { set Nachname "" }
if {[catch {cgi_import Email}]}    { set Email "" }

#
# Hauptprogramm
#

cgi_eval {
    cgi_html {
	cgi_head {
	    cgi_title Gstebuch
	}
	cgi_body {
	    cgi_h1 Gstebuch

	    #
	    # Ohne Parameter aufgerufen?
	    #
	    
	    if {[cgi_import_list] == {}} {
		show_form
		cgi_exit
	    }
	    
	    #
	    # Fehlerprfung
	    #
	    
	    if {$Nachname==""} {
		cgi_p [cgi_bold "Nachname mu angegeben werden!"]
		show_form
		cgi_exit
	    } elseif {$Email==""} {
		cgi_p [cgi_bold "Email mu angegeben werden!"]
		show_form
		cgi_exit
	    }

	    #
	    # Verbindung zur Datenbank aufbauen
	    #

	    if {[catch {pg_connect fp} conn]} {
		cgi_p [cgi_bold "Konnte Datenbank nicht ffnen!"]
		cgi_exit
	    }

	    #
	    # Haben wir schon einen Eintrag fr Vorname, Nachname?
	    #

	    set handle [pg_exec $conn "select id, email from gaestebuch\
		    where vorname='$Vorname'\
		    and nachname='$Nachname'"]
	    pg_result $handle -assign db
	    pg_result $handle -clear

	    #
	    # Drei Mglichkeiten:
	    #  1. Vorname, Name ist noch nicht eingetragen.
	    #  2. Vorname, Name ist bereits eingetragen,
	    #     Emailadresse hat sich gendert -> ndern
	    #  3. Vorname, Name ist bereits eingetragen,
	    #     Emailadresse unverndert -> Nix tun.
	    #

	    if {![info exists db(0,email)]} {
		set handle [pg_exec $conn "select max(id) from gaestebuch"]
		set maxid  [pg_result $handle -getTuple 0]
		pg_result $handle -clear
		incr maxid
		set handle [pg_exec $conn \
			"insert into gaestebuch values\
			($maxid,'$Vorname','$Nachname','$Email')"]
		cgi_p "Wir haben Sie ins Gstebuch aufgenommen."
		pg_result $handle -clear
	    } elseif {[info exists db(0,email)] && $db(0,email) != $Email} {
		set handle [pg_exec $conn \
			"update gaestebuch set email='$Email'\
			where id=$db(0,id)"]
		pg_result $handle -clear
		cgi_p "Emailadresse gendert."
		cgi_p "Vorher '$db(0,email)', jetzt '$Email'."
	    } else {
		cgi_p "Sie sind bereits im Gstebuch eingetragen."
	    }
    
	    catch {pg_disconnect $conn}
	}
    }
}
