#! /local/bin/tclsh8.0

puts -nonewline "Content-Type: text/html\r\n\r\n"
puts "<html><head><title>Gstebuch</title></head><body><h1>Gstebuch</h1>"

#
# CGI-Daten auswerten
# http://www.informatik.uni-frankfurt.de/~fp/Tcl/ProcCGIInput.tcl.txt
#

source /home/fp/CGI/ProcCGIInput.tcl

#
# Postgres-Modul laden
# Aus der PostgreSQL-Distribution, http://www.postgresql.org/
#

load /local/lib/libpgtcl80.so

#
# Formular ausgeben
#

proc show_form {} {
    global env

    puts "<form action=\"$env(SCRIPT_NAME)\">
<table>
<tr><th align=\"right\"> <b>Vorname</b>
    <td align=\"left\"> <input type=\"text\" name=\"vorname\" size=\"25\">
<tr><th align=\"right\"> <b>Nachname</b>
    <td align=\"left\"> <input type=\"text\" name=\"nachname\" size=\"25\">
<tr><th align=\"right\"> <b>Email</b>
    <td align=\"left\"> <input type=\"text\" name=\"email\" size=\"60\">
</table>

<input type=\"submit\" value=\"Eintragen\">
<input type=\"reset\" value=\"Abbrechen\">
</form>
</body>
</html>
"
}

#
# CGI-Daten auswerten
#

ProcCGIInput

#
# Ohne Parameter aufgerufen?
#

if {![array exists form]} {
    show_form
    exit 0
}

#
# Fehlerprfung
#

if {![info exists form(vorname)] || $form(vorname)==""} {
    puts "<b>Vorname mu angegeben werden!</b><p>"
    show_form
    exit 0
} elseif {![info exists form(nachname)] || $form(nachname)==""} {
    puts "<b>Nachname mu angegeben werden!</b><p>"
    show_form
    exit 0
} elseif {![info exists form(email)] || $form(email)==""} {
    puts "<b>Nachname mu angegeben werden!</b><p>"
    show_form
    exit 0
}

#
# Verbindung zur Datenbank aufbauen
#

if {[catch {pg_connect fp} conn]} {
    puts "<b>Konnte Datenbank nicht ffnen!</b></body></html>"
    exit 0
}

#
# Nachgucken, ob schon ein Eintrag fr Vorname, Nachname enthalten ist
#

set handle [pg_exec $conn "select id, email from gaestebuch\
                             where vorname='$form(vorname)'\
                               and nachname='$form(nachname)'"]
pg_result $handle -assign db
pg_result $handle -clear

#
# Drei Mglichkeiten:
#  1. Name ist noch nicht eingetragen.
#  1. Name ist bereits eingetragen, Emailadresse hat sich gendert -> ndern
#  2. Name ist bereits eingetragen, Emailadresse unverndert -> Nix tun.
#

if {![info exists db(0,email)]} {
    set handle [pg_exec $conn "select max(id) from gaestebuch"]
    set maxid  [pg_result $handle -getTuple 0]
    pg_result $handle -clear
    incr maxid
    set handle [pg_exec $conn \
     "insert into gaestebuch values\
        ($maxid,'$form(vorname)','$form(nachname)','$form(email)')"]
    puts "Wir haben Sie ins Gstebuch aufgenommen."
    pg_result $handle -clear
} elseif {[info exists db(0,email)] && $db(0,email) != $form(email)} {
    set handle [pg_exec $conn \
      "update gaestebuch set email='$form(email)' where id=$db(0,id)"]
    pg_result $handle -clear
    puts "Emailadresse gendert. Vorher '$db(0,email)', jetzt '$form(email)."
} else {
    puts "Sie sind bereits im Gstebuch eingetragen."
}
    
puts "</body></html>"
catch {pg_disconnect $conn}

