/* 
 * WelcomeRMIApplication.java
 */


package welcome;

import java.rmi.RemoteException;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import java.rmi.RMISecurityManager;
import java.awt.TextField;
import java.awt.Button;
import java.awt.Label;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.GridLayout;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

public class WelcomeRMIApplication extends Frame implements ActionListener
{
  String nachricht = "UNDEFINED";  // Nachricht, die im zweiten TextField ausgegeben wird
  TextField name;	// TextField, in das der Name eingegeben werden soll
  TextField ausgabe;	// TextField, in das die Nachricht vom Server ausgegeben wird
  Label nameLabel = new Label("Geben Sie Ihren Namen ein:");
  Label ausgabeLabel = new Label("Ausgabe vom RMI-Server:");
  Button button = new Button("Abschicken");
  
  // Panels, um die Komponenten schoen anordnen zu koennen
  Panel panel = new Panel();
  Panel panel2 = new Panel();
  Panel panel3 = new Panel();

  // Interface fuer die entfernte Methode
  WelcomeRMI welcomeRMI;

  public void run (String[] args)
  {
    // Die Server Hostadresse muss als Parameter uebergeben werden!

    String host = args[0];

      // Initialisierung und Anordnung der Komponenten
      name = new TextField(30);      
      ausgabe = new TextField(30);      
      panel.setLayout(new GridLayout(3, 1));
      panel2.setLayout(new FlowLayout());
      panel3.setLayout(new FlowLayout());
      panel2.add(nameLabel);
      panel2.add(name);
      panel.add(panel2);
      panel.add(button);
      panel3.add(ausgabeLabel);
      panel3.add(ausgabe);
      panel.add(panel3);
      add(panel);
      
      show();
      resize(400, 300);
          
      // Button beim ActionListener anmelden
      button.addActionListener(this);
      
    // fuer jrmp ...
    // -Djava.naming.factory.initial=com.sun.jndi.registry.RegistryContextFactory
    // fuer iiop ...
    // -Djava.naming.factory.initial=com.sun.jndi.cosnaming.CNCtxFactory

    String factory = System.getProperty ("java.naming.factory.initial");

    try
    {
      String hostName = args[0];

      if ( System.getSecurityManager() == null ) {
        System.setSecurityManager (new RMISecurityManager());
      }

      // Parameter in Properties schreiben
      Properties env = new Properties ();
      if ( factory.equals ("com.sun.jndi.cosnaming.CNCtxFactory") ) {
        env.put ("java.naming.provider.url", "iiop://" + host);
      } else {
        env.put ("java.naming.provider.url", "rmi://" + host);
      }

      // Kontext fuer das Durchfuehren der Operationen setzen 
      // (InitialContext gehoert zu der Erweiterung von JNDI)
      InitialContext context = new InitialContext (env);

      // Holt das gebundene Objekt mit dem Namen des Parameters   
      Object o = context.lookup ("WelcomeRMIServer");

      // ueberprueft, ob ein RMI-IIOP Objekt in einen gewuenschten Typ
      // gewandelt werden kann
      // erster Parameter ist das zu pruefende Objekt 
      // zweiter Parameter ist der gewuenschte Typ
      // Rueckgabewert ist ein Objekt, welches in den gewuenschten Typ gewandelt
      // werden kann
      welcomeRMI = (WelcomeRMI)PortableRemoteObject.narrow (o,WelcomeRMI.class);


    }
    catch (Exception e)
    {
      System.out.println ("exception: " + e.getMessage ());
      e.printStackTrace ();
    }

  }
  
  public void actionPerformed(ActionEvent e)
  {
    try
    {	
      // Name aus TextField auslesen
      String tname = name.getText();

      // Name an entfernte Methode uebergeben
      nachricht = welcomeRMI.message (tname);
      
      // Ausgabe der Servernachricht im zweiten TextField
      ausgabe.setText(nachricht);
    }
    catch (Exception ex)
    {
      System.out.println ("WelcomeRMIApplet: " + ex.getMessage ());
      ex.printStackTrace ();
    }
  }


  public static void main (String[] args)
  {
    WelcomeRMIApplication app = new WelcomeRMIApplication ();
    app.run (args);
  }

}
