/*
 * WelcomeRMIApplet 
 * Nach Eingabe des Namens in das erste TextField und Druecken des Buttons
 * wird der Name als Parameter an die Methode message des WelcomeRMIServers
 * weitergegeben. Der Rueckgabewert dieser Methode ist der String, der im
 * zweiten TextField als Ausgabe ausgegeben wird.
 */

package welcome;

import java.applet.Applet;
import java.awt.TextField;
import java.awt.Button;
import java.awt.Label;
import java.awt.Panel;
import java.awt.GridLayout;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;

public class WelcomeRMIApplet extends Applet implements ActionListener
{
  String nachricht = "UNDEFINED";  // Nachricht, die im zweiten TextField ausgegeben wird
  TextField name;	// TextField, in das der Name eingegeben werden soll
  TextField ausgabe;	// TextField, in das die Nachricht vom Server ausgegeben wird
  Label nameLabel = new Label("Geben Sie Ihren Namen ein:");
  Label ausgabeLabel = new Label("Ausgabe vom RMI-Server:");
  Button button = new Button("Abschicken");
  
  // Panels, um die Komponenten schoen anordnen zu koennen
  Panel panel = new Panel();
  Panel panel2 = new Panel();
  Panel panel3 = new Panel();
  
  // Interface fuer die entfernte Methode
  WelcomeRMI welcomeRMI;

  public WelcomeRMIApplet ()
  {
  }

  public void init ()
  {
    try
    {
    
      // Initialisierung und Anordnung der Komponenten
      name = new TextField(30);      
      ausgabe = new TextField(30);      
      panel.setLayout(new GridLayout(3, 1));
      panel2.setLayout(new FlowLayout());
      panel3.setLayout(new FlowLayout());
      panel2.add(nameLabel);
      panel2.add(name);
      panel.add(panel2);
      panel.add(button);
      panel3.add(ausgabeLabel);
      panel3.add(ausgabe);
      panel.add(panel3);
      add(panel);
    
      // Button beim ActionListener anmelden
      button.addActionListener(this);
      
      // Host auslesen
      String hostName = getCodeBase().getHost();

      // fuer jrmp ...
      // -Djava.naming.factory.initial=com.sun.jndi.registry.RegistryContextFactory
      // fuer iiop ...
      // -Djava.naming.factory.initial=com.sun.jndi.cosnaming.CNCtxFactory
      String factory = getParameter ("factory");
      
      // Portparameter auslesen (nur fuer Solaris wichtig)
      String port = getParameter ("org.omg.CORBA.ORBInitialPort");

      // Parameter aus HTML-Seite in Properties schreiben
      Properties env = new Properties ();
      env.put ("java.naming.applet", this);
      env.put ("java.naming.factory.initial", factory);

      if ( factory.equals ("com.sun.jndi.cosnaming.CNCtxFactory") ) {
        env.put ("org.omg.CORBA.ORBInitialPort", port);
        env.put ("java.naming.provider.url", "iiop://" + hostName);
      } else {
        env.put ("java.naming.provider.url", "rmi://" + hostName);
      }

      // Kontext fuer das Durchfuehren der Operationen setzen 
      // (InitialContext gehoert zu der Erweiterung von JNDI)
      InitialContext context = new InitialContext (env);
      
      // Holt das gebundene Objekt mit dem Namen     
      Object o = context.lookup ("WelcomeRMIServer");
      
      // ueberprueft, ob ein RMI-IIOP Objekt in einen gewuenschten Typ
      // gewandelt werden kann
      // erster Parameter ist das zu pruefende Objekt 
      // zweiter Parameter ist der gewuenschte Typ
      // Rueckgabewert ist ein Objekt, welches in den gewuenschten Typ gewandelt
      // werden kann
      welcomeRMI = (WelcomeRMI)PortableRemoteObject.narrow (o,WelcomeRMI.class);

    }
    catch (Exception e)
    {
      System.out.println ("WelcomeRMIApplet exception: " + e.getMessage ());
      e.printStackTrace ();
    }
  }
  
  public void actionPerformed(ActionEvent e)
  {
    try
    {	
      // Name aus TextField auslesen
      String tname = name.getText();

      // Name an entfernte Methode uebergeben
      nachricht = welcomeRMI.message (tname);
      
      // Ausgabe der Servernachricht im zweiten TextField
      ausgabe.setText(nachricht);
    }
    catch (Exception ex)
    {
      System.out.println ("WelcomeRMIApplet: " + ex.getMessage ());
      ex.printStackTrace ();
    }
  }

  public void paint (Graphics g)
  {
    ausgabe.setText(nachricht);
  }

}

