#include "SysInfoImp.hpp"
#include <ole2.h>

ULONG g_dwRefCount=0;

// {885E7E70-71AA-11d2-84A0-006008540659}
static const GUID CLSID_SysInfo = 
{ 0x885e7e70, 0x71aa, 0x11d2, { 0x84, 0xa0, 0x0, 0x60, 0x8, 0x54, 0x6, 0x59 } };



long MySysInfoFactory::CreateInstance(IUnknown *pUnkOuter, REFIID riid,
			            void **ppObject)
{
	if(pUnkOuter!=NULL)
	{
		return CLASS_E_NOAGGREGATION;
	}
	MySysInfo* pMySysInfo=new MySysInfo;
	if(FAILED(pMySysInfo->QueryInterface(riid, ppObject)))
	{
		delete pMySysInfo;
		*ppObject=NULL;
		return E_NOINTERFACE;
	}
	return NO_ERROR;
}

long MySysInfoFactory::LockServer(BOOL fLock)
{
	if(fLock)
		g_dwRefCount++;
	else
		g_dwRefCount--;

	return NO_ERROR;
}

MySysInfoFactory::MySysInfoFactory()
{
	m_dwRefCount=0;
	_fp = fopen("d:SysInfoF.log","w");
	if(_fp)
	 fprintf(_fp,"%s: \n","MySysInfoFactory()");
	else
	 cout << "not open" << endl;
}

MySysInfoFactory::~MySysInfoFactory()
{
	m_dwRefCount=0;
	if(_fp)
	{
     fprintf(_fp,"%s: \n","~MySysInfoFactory()");
	 fclose(_fp);
	}
}


HRESULT MySysInfoFactory::QueryInterface(REFIID riid, void **ppObject)
{
	if(riid==IID_IUnknown || riid==IID_IClassFactory)
	{
		*ppObject=(IMySysInfo*) this;
	}
	else
	{
		return E_NOINTERFACE;
	}
	AddRef();
	return NO_ERROR;
}


unsigned long MySysInfoFactory::AddRef()
{
	g_dwRefCount++;
	m_dwRefCount++;
	return m_dwRefCount;
}

unsigned long MySysInfoFactory::Release()
{
	g_dwRefCount--;
	m_dwRefCount--;
	if(m_dwRefCount==0)
	{
		delete this;
		return 0;
	}
	return m_dwRefCount;
}


STDAPI DllGetClassObject(REFCLSID rclsid, REFIID riid, void ** ppObject)
{
	if (rclsid == CLSID_SysInfo)
    {
	 MySysInfoFactory *pFactory=new MySysInfoFactory;
	 if (FAILED(pFactory->QueryInterface(riid, ppObject)))
	 {
		delete pFactory;
		*ppObject=NULL;
		return E_INVALIDARG;
	 }
	}
	else
	 return CLASS_E_CLASSNOTAVAILABLE;

	return NO_ERROR;
}

HRESULT _stdcall DllCanUnloadNow()
{
	if(g_dwRefCount)
	{
		return S_FALSE;
	}
	else
	{
		return S_OK;
	}

}


STDAPI DllRegisterServer(void) {
	HKEY hKeyCLSID, hKeyInproc32;
	DWORD dwDisposition;

	if (RegCreateKeyEx(HKEY_CLASSES_ROOT, 
			"CLSID\\{885E7E70-71AA-11d2-84A0-006008540659}", 
			NULL, "", REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, 
			&hKeyCLSID, &dwDisposition)!=ERROR_SUCCESS) {
		return E_UNEXPECTED;
		}

	if (RegSetValueEx(hKeyCLSID, "", NULL, REG_SZ, (BYTE*) "MySysInfo", sizeof("MySysInfo"))!=ERROR_SUCCESS) {
		RegCloseKey(hKeyCLSID);
		return E_UNEXPECTED;
		}

	if (RegCreateKeyEx(hKeyCLSID, 
			"InprocServer32", 
			NULL, "", REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, 
			&hKeyInproc32, &dwDisposition)!=ERROR_SUCCESS) {
		RegCloseKey(hKeyCLSID);
		return E_UNEXPECTED;
		}

	HMODULE hModule=GetModuleHandle("Server.DLL");
	if (!hModule) {
		RegCloseKey(hKeyInproc32);
		RegCloseKey(hKeyCLSID);
		return E_UNEXPECTED;
		}
	TCHAR szName[MAX_PATH+1];
	if (GetModuleFileName(hModule, szName, sizeof(szName))==0) {
		RegCloseKey(hKeyInproc32);
		RegCloseKey(hKeyCLSID);
		return E_UNEXPECTED;
		}
	if (RegSetValueEx(hKeyInproc32, "", NULL, REG_SZ, (BYTE*) szName, sizeof(TCHAR)*(lstrlen(szName)+1))!=ERROR_SUCCESS) {
		RegCloseKey(hKeyInproc32);
		RegCloseKey(hKeyCLSID);
		return E_UNEXPECTED;
		}
	RegCloseKey(hKeyInproc32);
	RegCloseKey(hKeyCLSID);
	return NOERROR;
}


STDAPI DllUnregisterServer(void)
{
	if(RegDeleteKey(HKEY_CLASSES_ROOT,
		"CLSID\\{885E7E70-71AA-11d2-84A0-006008540659}\\InprocServer32")!=ERROR_SUCCESS)
	{
		return E_UNEXPECTED;
	}

	if(RegDeleteKey(HKEY_CLASSES_ROOT,
		"CLSID\\{885E7E70-71AA-11d2-84A0-006008540659}")!=ERROR_SUCCESS)
	{
		return E_UNEXPECTED;
	}

	return NOERROR;
}
