#include "SysInfoImp.hpp"

// {BB1E9A70-8EE3-11d2-84BB-006008540659}
static const GUID IID_ISysInfo = 
{ 0xbb1e9a70, 0x8ee3, 0x11d2, { 0x84, 0xbb, 0x0, 0x60, 0x8, 0x54, 0x6, 0x59 } };


MySysInfo::MySysInfo()
{
	m_dwRefCount=0;
	_fp = fopen("d:SysInfo.log","w");
	if(_fp)
	 fprintf(_fp,"%s: \n","MySysInfo()");
	else
	 cout << "not open" << endl;
}

MySysInfo::~MySysInfo()
{
	if(_fp)
	{
     fprintf(_fp,"%s: \n","~MySysInfo()");
	 fclose(_fp);
	}
}

HRESULT MySysInfo::QueryInterface(REFIID riid, void **ppObject)
{
	if(riid==IID_IUnknown || riid==IID_ISysInfo)
	{
		*ppObject=(IMySysInfo*) this;
	}
	else
	{
		return E_NOINTERFACE;
	}
	AddRef();
	return NO_ERROR;
}


unsigned long MySysInfo::AddRef()
{
	g_dwRefCount++;
	m_dwRefCount++;
	return m_dwRefCount;
}

unsigned long MySysInfo::Release()
{
	g_dwRefCount--;
	m_dwRefCount--;
	if(m_dwRefCount==0)
	{
		delete this;
		return 0;
	}
	return m_dwRefCount;
}


void MySysInfo::GetSysInfo()
{
	GetSystemInfo( &sysinfo ); 
}

void MySysInfo::PrintSysInfo()
{
	cout << "Page Size: " << sysinfo.dwPageSize << endl; 
	cout << "Number of Processors: " << sysinfo.dwNumberOfProcessors << endl; 
	cout << "Procesor Level: " << sysinfo.wProcessorLevel << endl; 
	cout << "Processor Revision: " << sysinfo.wProcessorRevision << endl; 
}
