#! /bin/cssh

# file: AccountServer.cs

#
# Implementation of ServerMain line in CORBA Script

if ( sys.arg.length > 1 ) {
  name_server = sys.arg[1]
}

binding_name = [[name_server, ""]]

# The `import' instruction allows one to load a CorbaScript module.
import AccountImpl

AccountObject = AccountImpl.AccountImpl()

#
# The `_this' attribute refers to the DSI Corba Object implemented by
# `AccountObject' instance.
# The `_ior' attribute refers to the IOR of this DSI object.

theObjectReference = AccountObject._this
theIORString = theObjectReference._ior

println ("The IOR of the Account object is ",theIORString)

NS = CORBA.ORB.resolve_initial_references ("NameService")


try {
  NS.bind(binding_name, theObjectReference)
} catch (CosNaming.NamingContext.AlreadyBound exc) {
  println ("\nWARNING, the ", name_server, " entry is already used!")
return Void   # stop the current execution
}

# `CORBA.ORB.run()' starts the CorbaScript Object Adapter.
CORBA.ORB.run()

# Now, we must unregister the server from the Name Service.
NS.unbind(binding_name)
# And the server can stop

