#! /bin/cssh

# file: AccountClient.cs

# Nameserver
if ( sys.arg.length > 1 ) {
  name_server = sys.arg[1]
}


# Get Naming Service
NS = CORBA.ORB.resolve_initial_references ("NameService")

try {
  object = NS.resolve ([[name_server, ""]])
} catch (CosNaming.NamingContext.NotFound exc) {
  return Void   # stop the current execution
}

# Make sure the server is what we expect
if ( ! object._is_a(Account) ) {
  println ("Es ist kein Account Object")
  return Void
}

# Call the server
println("Balance is = ", object._get_balance())
object.makeLodgement(130.0)
println("Balance is = ", object._get_balance())

try {
  object.makeWithdrawal(345.0)
} catch (Account.reject ex) {
  println ("Got user exception:", ex.reason)
  return Void
}

try {
  println("Balance is = ", object._get_balance())
} catch (CORBA.SystemException ex) {
  println ("Got system exception:", ex)
  return Void
}

