//
// Perl/COPE Account Server
//

use strict;
use COPE::Account_types;

# IDL:Account:1.0
package Account_impl;
@Account_impl::ISA=qw();
use COPE::CORBA::Exception;

sub new {
    my($class,@args) = @_;
    my $self = {};
    return bless $self, $class;
}

sub balance ($) {
    my($self) = @_;
    return $balance;
}

sub makeLodgement ($$) {
    my($self,$amount) = @_;
    $$balance += $$amount;
}

sub makeWithdrawal ($$) {
    my($self,$amount) = @_;
    if ($$amount > $$balance) {
        throw new Account::reject reason => 'not allowed';
    } else {
        $$balance -= $$amount;
    }
}

#!/opt/perl/bin/perl -w
#

use Carp;

use strict;
use COPE::CORBA::ORB;
use COPE::Account_skel;
$|=1;

my $orb = CORBA::ORB_init();
my $boa = $orb->BOA_init();

my $account_skel = new Account_skel;
my $objref = $orb->object_to_string($account_skel);
print "$objref\n";

$boa->impl_is_ready();


