#!/usr/local/bin/perl


use Carp;
use strict;

use COPE::CORBA::ORB;
use COPE::CORBA::Exception;
use Config;
use AccountModule;

print "reading IOR of server object...\n";
open(IN, "server.ref") || die "can't open server.ref";
my $ref = "";
while(<IN>) {
    $ref = $_;
    print "read IOR as: $ref\n";
}
print "ORB_init()...\n";
my $orb = CORBA::ORB_init();
print "string_to_object()...\n";
my $obj = $orb->string_to_object($ref);
my $objref = AccountModule::Account->_narrow($obj);

print "\nbalance = ";
print $objref->balance();
$objref->makeLodgement(12);
print "\nbalance = ";
print $objref->balance();
$objref->makeWithdrawal(30);
print "\nbalance = ";
print $objref->balance();
