//---------------------------------------------------------------------------
#ifndef fkaviarH
#define fkaviarH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ComCtrls.hpp>
#include <Menus.hpp>
#include <Grids.hpp>
#include <OleCtrls.hpp>
#include <vcfi.hpp>
#include <ExtCtrls.hpp>
#include <Buttons.hpp>

class DField;
class DFieldDesc;

#define MAXFIELDS 128
//---------------------------------------------------------------------------
class TfrmKaviar : public TForm
{
__published:	// Komponenten, die von der IDE verwaltet werden
    TStatusBar *sb;
    TMainMenu *menu;
    TMenuItem *Datei1;
    TMenuItem *menConnect;
    TMenuItem *menDisconnect;
    TMenuItem *N1;
    TMenuItem *menQuit;
    TPageControl *PageCtrl;
    TTabSheet *DiskSheet;
    TVtChart *chart;
    TStringGrid *diskgrid;
    TMenuItem *menUpdate;
    TMenuItem *N2;
    TMenuItem *menSetup;
    TTabSheet *WhoSheet;
    TStringGrid *grdwho;
    TTabSheet *PsSheet;
    TStringGrid *grdps;
    TPopupMenu *popps;
    TMenuItem *Signal1;
    TMenuItem *SIGKILL1;
    void __fastcall FormCloseQuery(TObject *Sender, bool &CanClose);
    void __fastcall menConnectClick(TObject *Sender);

    void __fastcall FormResize(TObject *Sender);
    void __fastcall FormCreate(TObject *Sender);
    void __fastcall PageCtrlChange(TObject *Sender);
    void __fastcall FormDestroy(TObject *Sender);
    void __fastcall menSetupClick(TObject *Sender);
    void __fastcall menUpdateClick(TObject *Sender);
    void __fastcall menDisconnectClick(TObject *Sender);
    void __fastcall grdpsMouseDown(TObject *Sender, TMouseButton Button,
          TShiftState Shift, int X, int Y);
    void __fastcall SIGKILL1Click(TObject *Sender);
    void __fastcall menQuitClick(TObject *Sender);
private:	// Benutzerdeklarationen
	void  virtual __fastcall OnTcpEvent (TMessage& Msg);
	void  virtual __fastcall OnTcpMsg (TMessage& Msg);
	void  virtual __fastcall OnTcpData (TMessage& Msg);

public:		// Benutzerdeklarationen
    __fastcall TfrmKaviar(TComponent* Owner);

    BEGIN_MESSAGE_MAP
    	MESSAGE_HANDLER(WM_TCPEVENT, TMessage, OnTcpEvent)
    	MESSAGE_HANDLER(WM_TCPMSG, TMessage, OnTcpMsg)
    	MESSAGE_HANDLER(WM_TCPDATA, TMessage, OnTcpData)
    END_MESSAGE_MAP(TForm)

    enum EAPPSTATE {IDLE, READY, BUSY} AppState;
    void            SetAppState (enum EAPPSTATE s);
    void            UpdateDiskSheet ();
    enum {CMD, DISKFREE, WHO, PS} CurrentCmd;
    void            ServerCommand (char **Fields, int nfields);
    int             SplitField (char *p, char **Fields, int maxfld, int ifs);
    void            CopyLine2Grid (char *p, DFieldDesc* desc, TStringGrid *grid);
    void            PrepareGrid (DFieldDesc* pd, char **tbl, int max, TStringGrid* grid);
    void            Connect();
};
//---------------------------------------------------------------------------
extern PACKAGE TfrmKaviar *frmKaviar;

//---------------------------------------------------------------------------

class DField : public TObject {
public:
            DField () {
                start = length = type = index = 0;
            };
    int             start;
    int             length;
    int             type;
    int             index;
};

class DFieldDesc {
public:
            DFieldDesc () {
                Fields = new TStringList;
                Clear ();
            };
            ~DFieldDesc () {
                delete (Fields);
            };
    String          option;
    int             headerlines;
    int             currentline;
    TStringList*    Fields;
    void            Clear() {
                        headerlines = currentline = 0;
                        for (int i=0; i<Fields->Count; i++)
                            delete((DField*)Fields->Objects[i]);
                        Fields->Clear();
                        option = "";
                    };
};


#endif
